
;  ###----------------------------------------------------------------###
;  # file	: exc088.r						#
;  # date	: Mar 26 1996						#
;  # descr.	: functional test for Mips R3000			#
;  ###----------------------------------------------------------------###

		.reset

	;  ###--------------------------------------------------------###
	;  #   initialization prgram (hardware RESET)			#
	;  ###--------------------------------------------------------###

user_status	.equ	0x0000ff3c

reset_sw_int	.equ	0x00000000
user_prog	.equ	user_text_begin
user_stack	.equ	user_stack_begin

	;  ###--------------------------------------------------------###
	;  #   initialization prgram (hardware RESET)			#
	;  ###--------------------------------------------------------###

hardware_reset:
		li	r29, user_stack		; init user stack pointer

		li	r1 , user_status
		mtc0	r1 , status

		li	r26, user_prog

		li	r1 , reset_sw_int
		mtc0	r1 , cause

		jr	r26
		rfe				; return from reset

	;  ###--------------------------------------------------------###
	;  #   exception						#
	;  ###--------------------------------------------------------###

		.bexcep

exc_val         .equ    0x08
sim_addr	.equ	user_cntl_begin

	;  ###--------------------------------------------------------###
	;  #   signaling bad execution					#
	;  ###--------------------------------------------------------###

ex_it_handler:
unexpected_ex:
		li	r1 ,      sim_addr
		addiu	r2 , r0 , exc_val
		j	end_loop
		nop
end_loop:
		sb	r2 , 0(r1 )
		j	end_loop
		nop

		.end
