
;  ###----------------------------------------------------------------###
;  # file	: exc100.x						#
;  # date	: Mar 26 1996						#
;  # descr.	: functional test for Mips R3000			#
;  ###----------------------------------------------------------------###

		.excep

	;  ###--------------------------------------------------------###
	;  #   exceptions :						#
	;  #     - illegal swap address (swap using the system segment)	#
	;  ###--------------------------------------------------------###

exc_val         .equ    0x04
sim_addr	.equ	user_cntl_begin

exccode_mak	.equ	0x003c
syscall_excp	.equ	0x00000020		; syscall exception

	;  ###--------------------------------------------------------###
	;  #   interrupt and exception handler				#
	;  ###--------------------------------------------------------###

ex_it_handler:

	;  ###--------------------------------------------------------###
	;  #   save registers before beginning any action		#
	;  ###--------------------------------------------------------###

		addiu	r29, r29, -8

		sw	r27, 0 (r29)
		sw	r28, 4 (r29)

	;  ###--------------------------------------------------------###
	;  #   check for syscall exception (any other cause is trapped	#
	;  # to an endless loop)					#
	;  ###--------------------------------------------------------###

		li	r28, syscall_excp
		mfc0	r27, cause
		and	r27, r27, r28		; syscall exception ?
		beq	r27, r0 , other_causes
		nop

	;  ###--------------------------------------------------------###
	;  #   restore registers before returning :			#
	;  #								#
	;  #     the return address has been saved by the user program	#
	;  #     in r31 prior to the exception				#
	;  ###--------------------------------------------------------###

		lw	r27, 0 (r29)
		lw	r28, 4 (r29)

		addiu	r29, r29, 8

return:
		jr	r31
		rfe				; return from exception

	;  ###--------------------------------------------------------###
	;  #   signaling bad execution					#
	;  ###--------------------------------------------------------###

other_causes:
unexpected_ex:
		li	r1 ,      sim_addr
		addiu	r2 , r0 , exc_val
		j	end_loop
		nop
end_loop:
		sb	r2 , 0(r1 )
		j	end_loop
		nop

		.end
