
;  ###----------------------------------------------------------------###
;  # file	: swit000.x						#
;  # date	: Mar 26 1996						#
;  # descr.	: functional test for Mips R3000			#
;  ###----------------------------------------------------------------###

		.excep

	;  ###--------------------------------------------------------###
	;  #   exception and interrupt handler				#
	;  ###--------------------------------------------------------###

exc_val         .equ    0x04
sim_addr	.equ	user_cntl_begin

cause_mask	.equ	0x0000033c
software_it0	.equ	0x00000100

	;  ###--------------------------------------------------------###
	;  #   save registers before beginning any action		#
	;  ###--------------------------------------------------------###

ex_it_handler:
		addiu	r29, r29, -12

		sw	r28, 0 (r29)
		sw	r27, 4 (r29)
		sw	r26, 8 (r29)

	;  ###--------------------------------------------------------###
	;  #   check for software interrupt (any other cause is trapped	#
	;  # to an endless loop)					#
	;  ###--------------------------------------------------------###

		li	r27,      cause_mask
		li	r28,      software_it0
		mfc0	r26,      cause
		and	r26, r26, r27		; software interrupt 0 ?
		bne	r26, r28, other_causes
		nop

	;  ###--------------------------------------------------------###
	;  #   reset the interrupt request				#
	;  ###--------------------------------------------------------###

		li	r28,      ~software_it0
		mfc0	r26,      cause
		and	r26, r26, r28
		mtc0	r26,      cause

	;  ###--------------------------------------------------------###
	;  #   restore the return address into r31			#
	;  ###--------------------------------------------------------###

		mfc0	r31, epc

	;  ###--------------------------------------------------------###
	;  #   restore return registers before returning :		#
	;  #								#
	;  #     the return address has been saved by the user program	#
	;  #     in r31 prior to the exception				#
	;  ###--------------------------------------------------------###

		lw	r28, 0 (r29)
		lw	r27, 4 (r29)
		lw	r26, 8 (r29)

		addiu	r29, r29, 12
return:
		jr	r31
		rfe				; return from exception

	;  ###--------------------------------------------------------###
	;  #   signaling bad execution					#
	;  ###--------------------------------------------------------###

other_causes:
unexpected_ex:
		li	r1 ,      sim_addr
		addiu	r2 , r0 , exc_val
		j	end_loop
		nop
end_loop:
		sb	r2 , 0(r1 )
		j	end_loop
		nop

		.end
