#!/bin/bash

######################################################################
####                                                              ####
#### File    : test.sh                                            ####
#### Date    : December 16 2008                                   ####
#### Version : 1.02                                               ####
#### Author  : Belloeil Sophie                                    ####
####                                                              ####
#### Origin  : This description has been developed at LIP6        ####
####           University Paris 6 - Pierre et Marie Curie         ####
####           4 Place Jussieu 75252 Paris Cedex 05 - France      ####
####                                                              ####
######################################################################

usage(){
    echo "Usage $0 option"
    echo "     where option = {v1, v2, v3}"
    echo "      - v1 : Tests mips_r3000_1m.vbe"
    echo "      - v2 : Tests mips_r3000_1m.vst, mips_r3000_1m_core.vst, mips_r3000_1m_ct.vbe, mips_r3000_1m_dp.vbe"
    echo "      - v3 : Tests mips_r3000_1m.vst, mips_r3000_1m_core.vst, mips_r3000_1m_ct.vst, mips_r3000_1m_dp.vst"
    exit 127
}

if [ $# -ne 1 ]; then
    usage
fi
case $1 in
v1)
    cp ./share/CATAL_flat_VBE       ./CATAL
;;
v2)
    cp ./share/CATAL_hierarchie_VBE ./CATAL
;;
v3)
    cp ./share/CATAL_hierachie_VST  ./CATAL
;;
*)
    usage
;;
esac

export ALLIANCE_OS=Linux
export MBK_IN_LO=vst
export MBK_CATA_LIB=${MBK_CATA_LIB}:./cpu0:../mips:../design:../ram:../misc

for tests in `cat LISTE`
do
    echo "Testing $tests"
    ./SIM.csh $tests > res_$tests.log 2>&1
done
echo 'Tests ok :'
grep good *.log | wc -l
