
;  ###----------------------------------------------------------------###
;  # file	: exc049.x						#
;  # date	: Mar 26 1996						#
;  # descr.	: functional test for Mips R3000			#
;  ###----------------------------------------------------------------###

		.excep

	;  ###--------------------------------------------------------###
	;  #   exceptions :						#
	;  #     - coprocessor unusable exception (when executing a	#
	;  #       mfc0)						#
	;  ###--------------------------------------------------------###

exc_val         .equ    0x04
sim_addr	.equ	user_cntl_begin

exccode_mask	.equ	0x003c
cop_unuse_excp	.equ	0x0000002c		; coprocessor unusable exc.

ret_system_mode	.equ	0xfffffff7

	;  ###--------------------------------------------------------###
	;  #   interrupt and exception handler				#
	;  ###--------------------------------------------------------###

ex_it_handler:

	;  ###--------------------------------------------------------###
	;  #   save registers before beginning any action		#
	;  ###--------------------------------------------------------###

		addiu	r29, r29, -8

		sw	r27, 0 (r29)
		sw	r28, 4 (r29)

	;  ###--------------------------------------------------------###
	;  #   check for coproceesor unusable exception (any other	#
	;  # cause is trapped to an endless loop)			#
	;  ###--------------------------------------------------------###

		li	r28, cop_unuse_excp
		mfc0	r27, cause
		andi	r27, r27, exccode_mask	; coproceesor unusable exc ?
		bne	r27, r28, other_causes
		nop

	;  ###--------------------------------------------------------###
	;  #   before returning make the restored mode be system mode	#
	;  ###--------------------------------------------------------###

		mfc0	r28,      status
		li	r27,      ret_system_mode
		and	r28, r28, r27
		mtc0	r28,      status

	;  ###--------------------------------------------------------###
	;  #   restore registers before returning :			#
	;  #								#
	;  #     the return address has been saved by the user program	#
	;  #     in r31 prior to the exception				#
	;  ###--------------------------------------------------------###

		lw	r27, 0 (r29)
		lw	r28, 4 (r29)

		addiu	r29, r29, 8

return:
		jr	r31
		rfe				; return from exception

	;  ###--------------------------------------------------------###
	;  #   signaling bad execution					#
	;  ###--------------------------------------------------------###

other_causes:
unexpected_ex:
		li	r1 ,      sim_addr
		addiu	r2 , r0 , exc_val
		j	end_loop
		nop
end_loop:
		sb	r2 , 0(r1 )
		j	end_loop
		nop

		.end
