#!/usr/bin/env python

### -------------------------------------------------------------- ###
# file    : mips_r3000_dp.py                                         #
# date    : Jan 04 2010                                              #
# version : v1                                                       #
#                                                                    #
# origin  : this description has been developed at LIP6              #
#           University Paris 6 - Pierre et Marie Curie               #
#           4 Place Jussieu 75252 Paris Cedex 05 - France            #
#                                                                    #
# descr.  : data flow description of a five stage pipelined Mips     #
#           R3000 processor                                          #
#                                                                    #
# authors : Sophie Belloeil                                          #
### -------------------------------------------------------------- ###

from stratus import *

class mips_r3000_1m_dp ( Model ) :

  def Interface ( self ) :

    self.INTERACTIVE = self._param['interactive']

    self.ck          = SignalIn  ( "ck",           1 )    # external clock
    
    self.i           = SignalIn  ( "i",           32 )    # instruction
     
    self.d_in        = SignalIn  ( "d_in",        32 )    # data (input)
    self.d_out       = SignalOut ( "d_out",       32 )    # data (output)
                             
    self.addr        = SignalOut ( "addr",        32 )    # address

    self.rsdnbr_sd   = SignalIn  ( "rsdnbr_sd",   32 )    # source reg nbr
    self.rtdnbr_sd   = SignalIn  ( "rtdnbr_sd",   32 )    # source reg nbr
    
    self.hz_sdm_sd   = SignalIn  ( "hz_sdm_sd",    1 )    # s = d(i-2)
    self.hz_sdmw_sd  = SignalIn  ( "hz_sdmw_sd",   1 )    # s = d(i-3,i-2)
    self.hz_tdm_sd   = SignalIn  ( "hz_tdm_sd",    1 )    # t = d(i-2)
    self.hz_tdmw_sd  = SignalIn  ( "hz_tdmw_sd",   1 )    # t = d(i-3,i-2)

    self.hz_sdm_se   = SignalIn  ( "hz_sdm_se",    1 )    # s = d(i-1)
    self.hz_sdmw_se  = SignalIn  ( "hz_sdmw_se",   1 )    # s = d(i-2,i-1)
    self.hz_tdm_se   = SignalIn  ( "hz_tdm_se",    1 )    # t = d(i-1)
    self.hz_tdmw_se  = SignalIn  ( "hz_tdmw_se",   1 )    # t = d(i-2,i-1)
                          
    self.i_jr_sd     = SignalIn  ( "i_jr_sd",      1 )    # jump register
    self.btaken_sd   = SignalIn  ( "btaken_sd",    1 )    # branch taken
    self.i_allj_sd   = SignalIn  ( "i_allj_sd",    1 )    # all jumps
    self.i_link_sd   = SignalIn  ( "i_link_sd",    1 )    # link inst
                            
    self.iopsel_sd   = SignalIn  ( "iopsel_sd",    4 )    # i oper select
                             
    self.imdsgn_sd   = SignalIn  ( "imdsgn_sd",    1 )    # signed operands
    self.i_rsgnd_se  = SignalIn  ( "i_rsgnd_se",   1 )    # signed result
                            
    self.i_ifmt_se   = SignalIn  ( "i_ifmt_se",    1 )    # i format
    self.i_oper_se   = SignalIn  ( "i_oper_se",    7 )    # alu operation
    self.i_logic_se  = SignalIn  ( "i_logic_se",   2 )    # logic operation
    self.i_sub_se    = SignalIn  ( "i_sub_se",     1 )    # subtract
    self.i_right_se  = SignalIn  ( "i_right_se",   1 )    # shift right
                            
    self.setbit_se   = SignalIn  ( "setbit_se",    1 )    # result for set
                            
    self.datext_sm   = SignalIn  ( "datext_sm",    1 )    # data extension
    self.bytsub_sm   = SignalIn  ( "bytsub_sm",    3, 1 ) # byte substitute
    self.daccess_sm  = SignalIn  ( "daccess_sm",   1 )    # data access
    self.read_sm     = SignalIn  ( "read_sm",      1 )    # read operation
                            
    self.bubble_si   = SignalIn  ( "bubble_si",    1 )    # introduce  bubble
    self.hold_si     = SignalIn  ( "hold_si",      1 )    # hold the inst
    self.nothold_si  = SignalIn  ( "nothold_si",   1 )    # don't hold the inst
    self.shift_si    = SignalIn  ( "shift_si",     1 )    # shift new inst
    self.keep_si     = SignalIn  ( "keep_si",      1 )    # keep the data
    self.load_si     = SignalIn  ( "load_si",      1 )    # load a new data
                            
    self.notstall_sd = SignalIn  ( "notstall_sd",  1 )    # don't holdt inst
    self.bubble_sd   = SignalIn  ( "bubble_sd",    1 )    # introduce bubble
    self.hold_sd     = SignalIn  ( "hold_sd",      1 )    # hold the inst
    self.nothold_sd  = SignalIn  ( "nothold_sd",   1 )    # don't hold the inst
    self.shift_sd    = SignalIn  ( "shift_sd",     1 )    # shift new inst
    self.keep_sd     = SignalIn  ( "keep_sd",      1 )    # keep the data
    self.load_sd     = SignalIn  ( "load_sd",      1 )    # load a new data
                            
    self.bubble_se   = SignalIn  ( "bubble_se",    1 )    # introduce bubble
    self.hold_se     = SignalIn  ( "hold_se",      1 )    # hold the inst
    self.nothold_se  = SignalIn  ( "nothold_se",   1 )    # don't hold the inst
    self.shift_se    = SignalIn  ( "shift_se",     1 )    # shift new inst
    self.keep_se     = SignalIn  ( "keep_se",      1 )    # keep the data
    self.load_se     = SignalIn  ( "load_se",      1 )    # load a new data
                            
    self.bubble_sm   = SignalIn  ( "bubble_sm",    1 )    # introduce bubble
    self.hold_sm     = SignalIn  ( "hold_sm",      1 )    # hold the inst
    self.nothold_sm  = SignalIn  ( "nothold_sm",   1 )    # don't hold the inst
    self.shift_sm    = SignalIn  ( "shift_sm",     1 )    # shift new inst
    self.keep_sm     = SignalIn  ( "keep_sm",      1 )    # keep the data
    self.load_sm     = SignalIn  ( "load_sm",      1 )    # load a new data
                            
    self.wreg_sw     = SignalIn  ( "wreg_sw",     32 )    # integer reg wen
    self.wredopc_se  = SignalIn  ( "wredopc_se",   1 )    # redopc write en
                            
    self.wlo_sw      = SignalIn  ( "wlo_sw",       1 )    # low reg write en
    self.whi_sw      = SignalIn  ( "whi_sw",       1 )    # high reg write en
                            
    self.wepc_xx     = SignalIn  ( "wepc_xx",      1 )    # epc write en
    self.wepc_xm     = SignalIn  ( "wepc_xm",      1 )    # epc write en
                            
    self.bootev_xx   = SignalIn  ( "bootev_xx",    1 )    # bootstrap exc
                             
    self.badia_xm    = SignalIn  ( "badia_xm",     1 )    # bad inst adr
    self.badda_xm    = SignalIn  ( "badda_xm",     1 )    # bad data adr
                            
    self.lui_sd      = SignalIn  ( "lui_sd",       1 )    # lui inst
                            
    self.shamt_se    = SignalIn  ( "shamt_se",     5 )    # shift amount
                            
    self.reset_xx    = SignalIn  ( "reset_xx",     1 )    # synchro reset
    self.wnxtpc_xx   = SignalIn  ( "wnxtpc_xx",    1 )    # nxt inst ad wen
                            
    self.sr_cr_sd    = SignalIn  ( "sr_cr_sd",    32 )    # status/cause
    self.be_sd       = SignalIn  ( "be_sd",        1 )    # bad ad reg/epc
    self.scbe_sd     = SignalIn  ( "scbe_sd",      1 )    # c0 reg selection
                            
    self.bdslot_se   = SignalIn  ( "bdslot_se",    1 )
    self.bdslot_sm   = SignalIn  ( "bdslot_sm",    1 )
                            
    self.carith_32_se= SignalOut ( "carith_32_se", 1 )
    self.carith_31_se= SignalOut ( "carith_31_se", 1 )
    self.rarith_31_se= SignalOut ( "rarith_31_se", 1 )
    self.nextpc_1_se = SignalOut ( "nextpc_1_se",  1 )
    self.nextpc_0_se = SignalOut ( "nextpc_0_se",  1 )
    self.nextpc_31_se= SignalOut ( "nextpc_31_se", 1 )
                            
    self.res_sm      = SignalOut ( "res_sm",      32 )
                            
    self.s_31_sd     = SignalOut ( "s_31_sd",      1 )    # s (31)
    self.s_eq_t_sd   = SignalOut ( "s_eq_t_sd",    1 )    # s = t
    self.s_eq_z_sd   = SignalOut ( "s_eq_z_sd",    1 )    # s = 0
                            
    self.s_4_0_se    = SignalOut ( "s_4_0_se",     5 )    # s (4 downto 0)
                            
    self.test        = SignalIn  ( "test",         1 )    # test mode
    self.scin        = SignalIn  ( "scin",         1 )    # scan in
    self.scout       = SignalOut ( "scout",        1 )    # scan out
                            
    self.vdd         = VddIn ( "vdd" )
    self.vss         = VssIn ( "vss" )  

  def Netlist (self) :
    ### Signaux internes ###
    # A COMPLETER, MODIFIER ... Copie conforme de la liste du fichier vbe la uniquement pour vous faire gagner du temps d'écriture
    ck_sx       = Signal ( "ck_sx",      1 ) # internal clock
                                        
    i_ri        = Signal ( "i_ri",      32 ) # instruction reg
    i_rd        = Signal ( "i_rd",      32 ) # instruction reg
    i_re        = Signal ( "i_re",      32 ) # instruction reg
    i_rm        = Signal ( "i_rm",      32 ) # instruction reg
                              
    jadr_sd     = Signal ( "jadr_sd",   32 ) # next inst address
    badr_sd     = Signal ( "badr_sd",   32 ) # next inst address
    nextpc_sd   = Signal ( "nextpc_sd", 32 ) # next inst address
    nextpc_xx   = Signal ( "nextpc_xx", 32 ) # next inst adr (hw)
    nextpc_rd   = Signal ( "nextpc_rd", 32 ) # next inst address
    nextpc_re   = Signal ( "nextpc_re", 32 ) # next inst address
                              
    pc_ri       = Signal ( "pc_ri",     32 ) # instruction address
    pc_rd       = Signal ( "pc_rd",     32 ) # instruction address
    pc_re       = Signal ( "pc_re",     32 ) # instruction address
    redopc_re   = Signal ( "redopc_re", 32 ) # old inst address
                              
    s_sd        = Signal ( "s_sd",      32 ) # s from reg bank
    s_mw_sd     = Signal ( "s_mw_sd",   32 ) # effective s oper
    soper_sd    = Signal ( "soper_sd",  32 ) # effective s oper
    soper_rd    = Signal ( "soper_rd",  32 ) # effective s oper
                              
    t_sd        = Signal ( "t_sd",      32 ) # t from reg bank
    t_mw_sd     = Signal ( "t_mw_sd",   32 ) # effective t oper
    toper_sd    = Signal ( "toper_sd",  32 ) # effective t oper
    effto_sd    = Signal ( "effto_sd",  32 ) # effective t oper
    toper_rd    = Signal ( "toper_rd",  32 ) # effective t oper
                              
    s_mw_se     = Signal ( "s_mw_se",   32 ) # s operand
    soper_se    = Signal ( "soper_se",  32 ) # s operand
    xarith_se   = Signal ( "xarith_se", 32 ) # x oper for arithm

    t_mw_se     = Signal ( "t_mw_se",   32 ) # t operand
    toper_se    = Signal ( "toper_se",  32 ) # t operand
    yarith_se   = Signal ( "yarith_se", 32 ) # y oper for arithm
                              
    cop0op_sd   = Signal ( "cop0op_sd", 32 ) # cop 0 source opr
    br_epc_sd   = Signal ( "br_epc_sd", 32 ) # bad ad reg/epc
                              
    otheri_sd   = Signal ( "otheri_sd", 32 ) # immediate oper
    ioper_sd    = Signal ( "ioper_sd",  32 ) # eff immediate oper
    ioper_rd    = Signal ( "ioper_rd",  32 ) # eff immediate oper
                              
    s_cp_t_sd   = Signal ( "s_cp_t_sd", 32 ) # compare s & t
                              
    imdsex_sd   = Signal ( "imdsex_sd", 16 ) # offset extension
    offset_sd   = Signal ( "offset_sd", 32 ) # address offset
                              
    seqadr_sd   = Signal ( "seqadr_sd", 32 ) # sequential inst adr
    seqcry_sd   = Signal ( "seqcry_sd", 33 ) # carry (+ 4)

    jmpadr_sd   = Signal ( "jmpadr_sd", 32 ) # jump adress
    braadr_sd   = Signal ( "braadr_sd", 32 ) # branch adress
    bracry_sd   = Signal ( "bracry_sd", 33 ) # carry (+ offset)

    r1_rw       = Signal ( "r1_rw",     32 ) # integer reg # 1
    r2_rw       = Signal ( "r2_rw",     32 ) # integer reg # 2
    r3_rw       = Signal ( "r3_rw",     32 ) # integer reg # 3
    r4_rw       = Signal ( "r4_rw",     32 ) # integer reg # 4
    r5_rw       = Signal ( "r5_rw",     32 ) # integer reg # 5
    r6_rw       = Signal ( "r6_rw",     32 ) # integer reg # 6
    r7_rw       = Signal ( "r7_rw",     32 ) # integer reg # 7
    r8_rw       = Signal ( "r8_rw",     32 ) # integer reg # 8
    r9_rw       = Signal ( "r9_rw",     32 ) # integer reg # 9
    r10_rw      = Signal ( "r10_rw",    32 ) # integer reg # 10
    r11_rw      = Signal ( "r11_rw",    32 ) # integer reg # 11
    r12_rw      = Signal ( "r12_rw",    32 ) # integer reg # 12
    r13_rw      = Signal ( "r13_rw",    32 ) # integer reg # 13
    r14_rw      = Signal ( "r14_rw",    32 ) # integer reg # 14
    r15_rw      = Signal ( "r15_rw",    32 ) # integer reg # 15
    r16_rw      = Signal ( "r16_rw",    32 ) # integer reg # 16
    r17_rw      = Signal ( "r17_rw",    32 ) # integer reg # 17
    r18_rw      = Signal ( "r18_rw",    32 ) # integer reg # 18
    r19_rw      = Signal ( "r19_rw",    32 ) # integer reg # 19
    r20_rw      = Signal ( "r20_rw",    32 ) # integer reg # 20
    r21_rw      = Signal ( "r21_rw",    32 ) # integer reg # 21
    r22_rw      = Signal ( "r22_rw",    32 ) # integer reg # 22
    r23_rw      = Signal ( "r23_rw",    32 ) # integer reg # 23
    r24_rw      = Signal ( "r24_rw",    32 ) # integer reg # 24
    r25_rw      = Signal ( "r25_rw",    32 ) # integer reg # 25
    r26_rw      = Signal ( "r26_rw",    32 ) # integer reg # 26
    r27_rw      = Signal ( "r27_rw",    32 ) # integer reg # 27
    r28_rw      = Signal ( "r28_rw",    32 ) # integer reg # 28
    r29_rw      = Signal ( "r29_rw",    32 ) # integer reg # 29
    r30_rw      = Signal ( "r30_rw",    32 ) # integer reg # 30
    r31_rw      = Signal ( "r31_rw",    32 ) # integer reg # 31
    lo_rw       = Signal ( "lo_rw",     32 ) # low register
    hi_rw       = Signal ( "hi_rw",     32 ) # high register
    carith_se   = Signal ( "carith_se", 32 ) # carry in arithm
    rarith_se   = Signal ( "rarith_se", 32 ) # result of arithm

    xoper_se    = Signal ( "xoper_se",  32 ) # effective x operand
    yoper_se    = Signal ( "yoper_se",  32 ) # effective y operand

    shiftin_se  = Signal ( "shiftin_se", 32 ) # shift in
    shright_se  = Signal ( "shright_se", 32 ) # right shift result
    shlieft_se  = Signal ( "shleft_se", 32 ) # left shift result
    rshift_se   = Signal ( "rshift_se", 32 ) # shifter's result

    and_se      = Signal ( "and_se",    32 ) # logic oper. result
    or_se       = Signal ( "or_se",     32 ) # logic oper. result
    xor_se      = Signal ( "xor_se",    32 ) # logic oper. result
    ornor_se    = Signal ( "ornor_se",  32 ) # logic oper. result
    andxor_se   = Signal ( "andxor_se", 32 ) # logic oper. result
    rlogic_se   = Signal ( "rlogic_se", 32 ) # logic oper. result
    
    rtest_se    = Signal ( "rtest_se",  32 ) # test oper. result

    ra_rt_se    = Signal ( "ra_rt_se",  32 ) # arith/test result
    so_to_se    = Signal ( "so_to_se",  32 ) # soper/toper
    i_s_t_se    = Signal ( "i_s_t_se",  32 ) # ioper/soper/toper

    res_se      = Signal ( "res_se",    32 ) # result out of alu
    res_re      = Signal ( "res_re",    32 ) # result out of alu

    wdata_re    = Signal ( "wdata_re",  32 ) # data bus output reg

    d_15x_sm    = Signal ( "d_15x_sm",  24, 8 ) # read data
    d_31x_sm    = Signal ( "d_31x_sm",  24, 8 ) # read data
    d_ext_sm    = Signal ( "d_ext_sm",  24, 8 ) # read data
    data_e_sm   = Signal ( "data_e_sm", 32 )    # read data
    data_o_sm   = Signal ( "data_o_sm", 32 )    # read data
    data_x_sm   = Signal ( "data_x_sm", 32 )    # read data
                              
    reddat_sm   = Signal ( "reddat_sm",  32 ) # aligned data
                              
    data_sm     = Signal ( "data_sm",    32 ) # data bus / res
    data_rm     = Signal ( "data_rm",    32 ) # data bus input reg
 
    badvadr_rm  = Signal ( "badvadr_rm", 32 ) # bad virtual adr reg
                              
    epc_xx      = Signal ( "epc_xx",     32 ) # exc pg counter
    epc_xm      = Signal ( "epc_xm",     32 ) # exc pg counter
    epc_rx      = Signal ( "epc_rx",     32 ) # exc pg counter reg

    r0_rw       = Signal ( "r0_rw",      32 )

    nop_i       = Signal ( "nop_i",      32 ) # addu 0,0,0

    m_writ_w    = Signal ( "m_writ_w",    2 ) # write word
    m_writ_h    = Signal ( "m_writ_h",    2 ) # write half
    m_writ_b    = Signal ( "m_writ_b",    2 ) # write bit
    m_read_b    = Signal ( "m_read_b",    2 ) # read bit

    excphnd_a   = Signal ( "excphnd_a",  32 ) # handler adr
    boothnd_a   = Signal ( "boothnd_a",  32 ) # handler adr
    reset_a     = Signal ( "reset_a",    32 ) # reset   adr

    badvaddr_s  = Signal ( "badvaddr_s",  5 ) # badvaddr
    status_s    = Signal ( "status_s",    5 ) # status
    cause_s     = Signal ( "cause_s",     5 ) # cause
    epc_s       = Signal ( "epc_s",       5 ) # epc
    prid_s      = Signal ( "prid_s",      5 ) # prid
                                      
    r_fmt_o     = Signal ( "r_fmt_o",     4 ) # r format
    i_fmt_o     = Signal ( "i_fmt_o",     4 ) # i format
    j_fmt_o     = Signal ( "j_fmt_o",     4 ) # j format
    illgl_o     = Signal ( "illgl_o",     4 ) # illegal ins
                                      
    d_use_st_o  = Signal ( "d_use_st_o",  4 ) # dec use st
    d_use_s_o   = Signal ( "d_use_s_o",   4 ) # dec use s
    d_use_t_o   = Signal ( "d_use_t_o",   4 ) # dec use t
    e_use_st_o  = Signal ( "e_use_st_o",  4 ) # exe use st
    e_use_s_o   = Signal ( "e_use_s_o",   4 ) # exe use s
    e_use_t_o   = Signal ( "e_use_t_o",   4 ) # exe use  t
    no_use_o    = Signal ( "no_use_o",    4 ) # no  oper
   
    o_signd_o   = Signal ( "o_signd_o",   1 ) # signed
    o_usign_o   = Signal ( "o_usign_o",   1 ) # unsigned
   
    arith_o     = Signal ( "arith_o",     7 ) # arith  oper
    test_o      = Signal ( "test_o",      7 ) # test   oper
    logic_o     = Signal ( "logic_o",     7 ) # logic  oper
    shift_o     = Signal ( "shift_o",     7 ) # shift  oper
    soper_o     = Signal ( "soper_o",     7 ) # take s oper
    toper_o     = Signal ( "toper_o",     7 ) # take t oper
    ioper_o     = Signal ( "ioper_o",     7 ) # take i oper
                                    
    add_o       = Signal ( "add_o",       2 ) # add oper
    sub_o       = Signal ( "sub_o",       2 ) # sub oper
                                    
    sleft_o     = Signal ( "sleft_o",     2 ) # shift left
    sright_o    = Signal ( "sright_o",    2 ) # shift right
                                    
    or_o        = Signal ( "or_o",        2 ) # or  oper
    and_o       = Signal ( "and_o",       2 ) # and oper
    xor_o       = Signal ( "xor_o",       2 ) # xor oper
    nor_o       = Signal ( "nor_o",       2 ) # nor oper
   
    r_signd_o   = Signal ( "r_signd_o",   1 ) # sign   res
    r_usign_o   = Signal ( "r_usign_o",   1 ) # unsign res
   
    ovr_o       = Signal ( "ovr_o",       1 ) #    overflow
    nov_o       = Signal ( "nov_o",       1 ) # no overflow
   
    e_pdc_rd_o  = Signal ( "e_pdc_rd_o",  3 ) # res out exe
    e_pdc_31_o  = Signal ( "e_pdc_31_o",  3 ) # res out exe
    m_pdc_rd_o  = Signal ( "m_pdc_rd_o",  3 ) # res out mem
    no_pdc_o    = Signal ( "no_pdc_o",    3 ) # no result
   
    nobra_o     = Signal ( "nobra_o",     1 ) # no branch
    brnch_o     = Signal ( "brnch_o",     1 ) # branch
   
    loadw_o     = Signal ( "loadw_o", 5 ) # load word
    loadh_o     = Signal ( "loadh_o", 5 ) # load half
    loadb_o     = Signal ( "loadb_o", 5 ) # load byte
    storw_o     = Signal ( "storw_o", 5 ) # store word
    storh_o     = Signal ( "storh_o", 5 ) # store half
    storb_o     = Signal ( "storb_o", 5 ) # store byte
    swapw_o     = Signal ( "swapw_o", 5 ) # swap word
    nomem_o     = Signal ( "nomem_o", 5 ) # no access  


    ### Creation des Generateurs utiles ###
    # A COMPLETER, MODIFIER ...
    Generate('DpgenConst', "instnop_i",     param= { 'nbit' : 32, 'const' : "0x00000021" } ) 
    Generate('DpgenConst', "instexcphnd_a", param= { 'nbit' : 32, 'const' : "0x80000080" } ) 
    Generate('DpgenConst', "instboothnd_a", param= { 'nbit' : 32, 'const' : "0xbfc00180" } ) 
    Generate('DpgenConst', "instreset_a",   param= { 'nbit' : 32, 'const' : "0xbfc00000" } ) 
    Generate("DpgenConst", 'const0000',     param= { 'nbit' : 16, 'const' : "0x0000" } )
    Generate("DpgenConst", 'const0_2',      param= { 'nbit' :  2, 'const' : "0b00" } )
    Generate("DpgenConst", 'const4_32',     param= { 'nbit' : 32, 'const' : "0x00000004" } )
    Generate('DpgenConst', "const0_1",      param= { 'nbit' :  1, 'const' : "0b0" } )
    Generate('DpgenConst', "const1_1",      param= { 'nbit' :  1, 'const' : "0b1" } )
    Generate("DpgenConst", 'const0_31',     param= { 'nbit':  31, 'const' : "0b0000000000000000000000000000000" } )


    ### Instanciation ###
    # A FAIRE
