/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#include "correc_block.h"
#include "utils.h"

void correc_luma_block(frame_t *f, mb_fifo_luma_t *mb_fifo_L, int x, int y, int luma4x4BlkIdx)
{
    int i, j;
    for (j=0; j<4; j++)
    {
        for (i=0; i<4; i++)
        {
            unsigned char *img = &L_pixel (f, x+i, y+j);
            int pixel = *img + mb_fifo_L->LumaACLevel[luma4x4BlkIdx][j*4+i];
            *img = Clip(pixel, 0, 255);
        }
    }
}

void correc_chroma_block(frame_t *f, mb_fifo_chroma_t *mb_fifo_C, int x, int y, int chroma4x4BlkIdx, int iCbCr)
{
    int i, j;
    for (j=0; j<4; j++)
    {
        for (i=0; i<4; i++)
        {
            unsigned char *img = &C_pixel (f, iCbCr, x+i, y+j);
            int pixel = *img + mb_fifo_C->ChromaACLevel[iCbCr][chroma4x4BlkIdx][j*4+i];
            *img = Clip(pixel, 0, 255);
        }
    }
}
