/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#ifndef H264_H
#define H264_H

/* This header is especially written for the Foreman.264 movie */

/* Sizes */
#define WIDTH   (VIDEO_WIDTH)
#define HEIGHT  (VIDEO_HEIGHT)
#define CWIDTH  (WIDTH/2)
#define CHEIGHT (HEIGHT/2)

#define MBLOCK_WIDTH    16
#define MBLOCK_HEIGHT   16
#define MBLOCK_SIZE     (MBLOCK_WIDTH*MBLOCK_HEIGHT)
#define MBLOCKS_X       (WIDTH/MBLOCK_WIDTH)
#define MBLOCKS_Y       (HEIGHT/MBLOCK_HEIGHT)
#define NMBLOCKS        (MBLOCKS_X*MBLOCKS_Y)

#define CBLOCK_WIDTH    8
#define CBLOCK_HEIGHT   8
#define CBLOCK_SIZE     (CBLOCK_WIDTH*CBLOCK_HEIGHT)
#define CBLOCKS_X       ((WIDTH/2)/CBLOCK_WIDTH)*2 // *2 because dct on 4x4 blocks
#define CBLOCKS_Y       ((HEIGHT/2)/CBLOCK_HEIGHT)*2

#define TBLOCK_WIDTH    4
#define TBLOCKS_X       (WIDTH/TBLOCK_WIDTH)

/* slice types */
#define  P_SLICE  0
#define  B_SLICE  1
#define  I_SLICE  2
#define SP_SLICE  3
#define SI_SLICE  4

/* mb types */
#define NA              -1

#define Intra_4x4       0
#define Intra_16x16     1
#define Pred_L0         2
#define Pred_L1         3
#define BiPred          4
#define Direct          5

#define P_L0_16x16      0
#define P_L0_L0_16x8    1
#define P_L0_L0_8x16    2
#define P_8x8           3
#define P_8x8ref0       4
#define I_4x4           5
#define I_16x16_0_0_0   6
#define I_16x16_1_0_0   7
#define I_16x16_2_0_0   8
#define I_16x16_3_0_0   9
#define I_16x16_0_1_0  10
#define I_16x16_1_1_0  11
#define I_16x16_2_1_0  12
#define I_16x16_3_1_0  13
#define I_16x16_0_2_0  14
#define I_16x16_1_2_0  15
#define I_16x16_2_2_0  16
#define I_16x16_3_2_0  17
#define I_16x16_0_0_1  18
#define I_16x16_1_0_1  19
#define I_16x16_2_0_1  20
#define I_16x16_3_0_1  21
#define I_16x16_0_1_1  22
#define I_16x16_1_1_1  23
#define I_16x16_2_1_1  24
#define I_16x16_3_1_1  25
#define I_16x16_0_2_1  26
#define I_16x16_1_2_1  27
#define I_16x16_2_2_1  28
#define I_16x16_3_2_1  29
#define I_PCM          30
#define P_Skip         31 

#define P_L0_8x8       0
#define P_L0_8x4       1
#define P_L0_4x8       2
#define P_L0_4x4       3
#define B_Direct_8x8   4

#define IsInter(m)  (((m)>=0 && (m)<5) || (m)==P_Skip)
#define IsIntra(m)  ((m)>=5 && (m)<=I_PCM)

/* scan order inside a mb */
static const unsigned char MBScanOrder[16][2]={
  { 0, 0},  { 4, 0},  { 0, 4},  { 4, 4},
  { 8, 0},  {12, 0},  { 8, 4},  {12, 4},
  { 0, 8},  { 4, 8},  { 0,12},  { 4,12},
  { 8, 8},  {12, 8},  { 8,12},  {12,12}
};

#define min(x,y) ((x) < (y) ? (x) : (y))
#define max(x,y) ((x) < (y) ? (y) : (x))
#define Clip(i,min,max) (((i)<min)?min:(((i)>max)?max:(i)))
//#define abs(x)  (((x)<0) ? -(x):(x))

#endif
