/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#ifndef __INTRA_RENDER_H
#define __INTRA_RENDER_H

#include "render.h"
#include "mb_fifo.h"
#include "h264.h"

void Intra_4x4_Dispatch(frame_t *f, mb_fifo_global_t *mb_fifo_G, int x, int y, int luma4x4BlkIdx, 
                        unsigned char intra_pred_flag);

void Intra_16x16_Dispatch(frame_t *f, mb_fifo_global_t *mb_fifo_G, 
                            unsigned char intra_pred_flag);

void Intra_Chroma_Dispatch(frame_t *f, mb_fifo_global_t *mb_fifo_G, 
                            unsigned char intra_pred_flag);

#endif /*__INTRA_PRED_H__*/
