/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#ifndef _RENDER_H
#define _RENDER_H

#include "h264.h"

typedef struct {
    unsigned char *L;
    unsigned char *C[2];
    unsigned int m_available[MBLOCKS_Y][MBLOCKS_X];
} frame_t;

#define L_pixel(f,x,y)          ((f)->L[(y)*WIDTH+(x)])
#define Cb_pixel(f,x,y)         ((f)->C[0][(y)*CWIDTH+(x)])
#define Cr_pixel(f,x,y)         ((f)->C[1][(y)*CWIDTH+(x)])
#define C_pixel(f,iCbCr,x,y)    ((f)->C[iCbCr][(y)*CWIDTH+(x)])

#endif
