/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#include "mb_fifo.h"

inline void Fill_PSkip ( mb_fifo_global_t *mb_fifo_G, char MbMode, int MVx, int MVy )
{
    int i;
    mb_fifo_G->MbMode = MbMode;
    mb_fifo_G->MbPartPredMode = Pred_L0;
    for (i=0; i<16; i++)
    {
        mb_fifo_G->inter.MVx[i] = MVx;
        mb_fifo_G->inter.MVy[i] = MVy;
    }
    mb_fifo_G->CodedBlockPatternLuma = 0;
    mb_fifo_G->CodedBlockPatternChroma = 0;
}

inline void Fill_Inter ( mb_fifo_global_t *mb_fifo_G, mode_pred_inf_t *mpi, 
                  char MbMode, unsigned char MbPartPredMode )
{
    int x, y;
    mb_fifo_G->MbMode = MbMode;
    mb_fifo_G->MbPartPredMode = MbPartPredMode;
    for(y=0; y<4; ++y)
    {
        for(x=0; x<4; ++x)
        {
            mb_fifo_G->inter.MVx[x + y*4] = ModePredInfo_MVx(mpi, 
                    (mb_fifo_G->mb_pos_x>>2) + x, 
                    (mb_fifo_G->mb_pos_y>>2) + y);
            mb_fifo_G->inter.MVy[x + y*4] = ModePredInfo_MVy(mpi,
                    (mb_fifo_G->mb_pos_x>>2) + x, 
                    (mb_fifo_G->mb_pos_y>>2) + y);
        }
    }
}


inline void Fill_Intra ( mb_fifo_global_t *mb_fifo_G, mode_pred_inf_t *mpi,  
                  char MbMode, unsigned char MbPartPredMode )
{
    mb_fifo_G->MbMode = MbMode;
    mb_fifo_G->MbPartPredMode = MbPartPredMode;

    /* left mb */
    mb_fifo_G->intra.SurMbMode[0] = get_mb_mode(mpi, (mb_fifo_G->mb_pos_x>>4)-1, (mb_fifo_G->mb_pos_y>>4));
    /* upper mb */
    mb_fifo_G->intra.SurMbMode[1] = get_mb_mode(mpi, (mb_fifo_G->mb_pos_x>>4), (mb_fifo_G->mb_pos_y>>4)-1);
}

inline void Fill_CodedPattern ( mb_fifo_global_t *mb_fifo_G, 
                         unsigned char CodedBlockPatternLuma, 
                         unsigned char CodedBlockPatternChroma )
{
    mb_fifo_G->CodedBlockPatternLuma = CodedBlockPatternLuma;
    mb_fifo_G->CodedBlockPatternChroma = CodedBlockPatternChroma;
}

