/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#include <srl.h>
#include "merge_proto.h"

#include "h264.h"
#include "utils.h"

FUNC(merge)
{
    srl_mwmr_t input_mwmr[] = {
        GET_ARG(input0),
#if NB_PIPES >= 2
        GET_ARG(input1),
#endif
#if NB_PIPES >= 3
        GET_ARG(input2),
#endif
#if NB_PIPES >= 4
        GET_ARG(input3),
#endif
#if NB_PIPES >= 5
#error "Max value authorized for NB_PIPES :  4"
#endif
    };
    srl_mwmr_t valid_input_mwmr[] = {
        GET_ARG(valid_input0),
#if NB_PIPES >= 2
        GET_ARG(valid_input1),
#endif
#if NB_PIPES >= 3
        GET_ARG(valid_input2),
#endif
#if NB_PIPES >= 4
        GET_ARG(valid_input3),
#endif
#if NB_PIPES >= 5
#error "Max value authorized for NB_PIPES :  4"
#endif
    };
    //srl_mwmr_t output_mwmr  = GET_ARG(output);
    srl_memspace_t fb_memspace = GET_ARG(fb_mem_space);
    volatile char *fb = SRL_MEMSPACE_ADDR(fb_memspace);

    unsigned char LumaBuffer[MBLOCK_SIZE];
    unsigned char ChromaBuffer[CBLOCK_SIZE];
    
    //unsigned char LumaLineBuffer[WIDTH*MBLOCK_HEIGHT];
    //unsigned char ChromaLineBuffer[2][CWIDTH*CBLOCK_HEIGHT];

    unsigned char current_pipe = 0;
    
	while (1)
	{
		srl_log(TRACE, "LIBU thread is starting...\n");

		int line, column;

		/* line by line of macroblock */
		for (line=0; line<MBLOCKS_Y; ++line ) {

            unsigned char *LumaLineBuffer;
            unsigned char *ChromaLineBuffer[2];
            LumaLineBuffer = &fb[0] + line*MBLOCK_HEIGHT*WIDTH;
            ChromaLineBuffer[0] = &fb[WIDTH*HEIGHT] + line*CBLOCK_HEIGHT*CWIDTH;
            ChromaLineBuffer[1] = &fb[WIDTH*HEIGHT+CWIDTH*CHEIGHT] + line*CBLOCK_HEIGHT*CWIDTH;

			srl_log_printf(TRACE, "(LIBU) - Processing stripe %d/%d\n", line+1, MBLOCKS_Y);

			/* column by column of macroblock */
			for (column=0; column<MBLOCKS_X; ++column ) {
				int i, iCbCr;

				srl_log_printf(TRACE, "(LIBU) - Reading Macroblock %d/%d\n", 
						column+1, MBLOCKS_X);

                int valid;
                while(1)
                {
                    srl_mwmr_read(valid_input_mwmr[current_pipe], (unsigned char*)&valid, 4);
                    if (!valid)
                        current_pipe = (current_pipe + 1)%NB_PIPES;
                    else
                        break;
                }
				srl_log_printf(TRACE, "(LIBU) - Reading from Decode thread %d\n", current_pipe);
                
				/** Luma **/
				srl_log_printf(TRACE, "(LIBU) - Reading Luma from Render\n");
				srl_mwmr_read(input_mwmr[current_pipe], &LumaBuffer[0], (MBLOCK_SIZE));

				//LUMA_PRINT;

				for (i=0; i<MBLOCK_HEIGHT; ++i ) {
					memcpy( &LumaLineBuffer[i*WIDTH+MBLOCK_WIDTH*column],
							&LumaBuffer[i*MBLOCK_WIDTH],
							MBLOCK_WIDTH );
				}

				/** Chroma **/
				for (iCbCr=0; iCbCr<2; iCbCr++)
				{
					srl_log_printf(TRACE, "(LIBU) - Reading Chroma[%d] from Render\n", 
							iCbCr);
					srl_mwmr_read(input_mwmr[current_pipe], &ChromaBuffer[0], (CBLOCK_SIZE));

					//CHROMA_PRINT;

					for (i=0; i<CBLOCK_HEIGHT; ++i ) {
						memcpy( &ChromaLineBuffer[iCbCr][i*CWIDTH+CBLOCK_WIDTH*column],
								&ChromaBuffer[i*CBLOCK_WIDTH],
								CBLOCK_WIDTH );
					}
				}
			}

			///* transmit the whole Y line of macroblocks */
			//srl_mwmr_write(output_mwmr, (unsigned char*)LumaLineBuffer, WIDTH*MBLOCK_HEIGHT/4);
			///* transmit the whole Cb line of macroblocks */
			//srl_mwmr_write(output_mwmr, (unsigned char*)ChromaLineBuffer[0], CWIDTH*CBLOCK_HEIGHT/4);
			///* transmit the whole Cr line of macroblocks */
			//srl_mwmr_write(output_mwmr, (unsigned char*)ChromaLineBuffer[1], CWIDTH*CBLOCK_HEIGHT/4);

		} // end for
	} // end while
}
