#!/usr/bin/env python
from dsx import *
from soclib import *

from config import config

## Mwmr width ##
tg264_demux_width   = 128
demux_decode_width  = 128 # size of a slice segment
decode_merge_width  = 8*8 # gcd of luma and chroma macroblock

## Misc ##
nb_plane_buffers    = 3
video_size          = config.width * config.height

## Memspace size ##
framebuffer_size    = video_size+2*(video_size/4)
plane_buffers_size  = nb_plane_buffers*(framebuffer_size)
plane_pool_size     = 4 + nb_plane_buffers*(3*4 + 4*video_size/(16*16)) + 20
parameter_set_size  = 12+16

### TG: provide video stream ###
tg264 = TaskModel(
        'tg264',
        ports   = { 'output':MwmrOutput(tg264_demux_width) },
        impls   = [ SwTask ( 'tg264',
            bootstrap   = 'bootstrap',
            stack_size  = 1024,
            sources     = [ 'src/thread_tg264.c' ],
            defines     = [ 'FILE_NAME', 'OUT_FIFO_WIDTH' ]
            ),
            SyntheticTask( defines = {
                'FILE_NAME':'"%s"'%config.file,
                'OUT_FIFO_WIDTH':str(tg264_demux_width)
                } )
            ] 
        )

### Demux: slice dispatcher for decoding threads ###
ports = {}
for i in map(lambda x:'output%d'%x, range(config.pipes)):
    ports[i] = MwmrOutput(demux_decode_width)
ports['input'] = MwmrInput(tg264_demux_width)
ports['parameter_set'] = MemspacePort(parameter_set_size)
demux = TaskModel(
        'demux',
        ports,
        impls   = [ SwTask( 'demux',
            stack_size = 1024,
            sources = [ 'src/thread_slice_demux.c', 
                'src/bitstream_io.c', 
                'src/parameter_set.c'
                ],
            defines = [ 'IN_FIFO_WIDTH', 
                'SLICE_WIDTH',
                'VIDEO_WIDTH', 
                'VIDEO_HEIGHT',
                'NB_PIPES'
                ] 
            ) ] 
        )

### Decode: h264 slices decoding thread ###
decode = TaskModel(
        'decode',
        ports   = {

            'input':MwmrInput(demux_decode_width),
            'output':MwmrOutput(decode_merge_width),
            'valid_output':MwmrOutput(4),
            'plane_buffers':MemspacePort(plane_buffers_size),
            'plane_pool':MemspacePort(plane_pool_size), 
            'parameter_set':MemspacePort(parameter_set_size),
            'barrier':BarrierPort(),
            'pipe_id':ConstPort()
        },
        impls   = [ SwTask( 'decode',
            stack_size = 8192,
            sources = [ 'src/thread_decode.c', 
                'src/bitstream_io.c', 
                'src/dec_bitstream.c',
                'src/modepredinfo.c',
                'src/mb_fifo.c',
                'src/plane_pool.c',
                'src/intra_render.c',
                'src/inter_render.c',
                'src/transform.c',
                'src/correc_block.c'
                ], 
            defines = [ 'SLICE_WIDTH', 
                'OUT_FIFO_WIDTH', 
                'VIDEO_WIDTH', 
                'VIDEO_HEIGHT',
                'VIDEO_FRAMES',
                'NB_PLANE_BUFFERS'
                ] 
            )
            ] 
        )

### Merge: merge slices into frames ###
ports = {}
for i in map(lambda x:'input%d'%x, range(config.pipes)):
    ports[i] = MwmrInput(decode_merge_width)
for i in map(lambda x:'valid_input%d'%x, range(config.pipes)):
    ports[i] = MwmrInput(4)
ports['fb_mem_space'] = MemspacePort(framebuffer_size)
merge = TaskModel(
        'merge',
        ports,
        impls   = [ SwTask( 'merge',
            stack_size = 16384,
            sources = [ 'src/thread_merge_filter.c' ],
            defines = [ 'IN_FIFO_WIDTH', 
                'VIDEO_WIDTH', 
                'VIDEO_HEIGHT',
                'NB_PIPES'
                ]
            )
            ] 
        )

