/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#ifndef _MB_FIFO_H
#define _MB_FIFO_H

#include "h264.h"
#include "modepredinfo.h"

/* structure sent by slice thread to idct thread through fifomwmr */
typedef struct {
    /* general infos */
    char MbMode;                                // 1
    unsigned char MbPartPredMode;               // 1
    unsigned int mb_pos_x;                      // 4
    unsigned int mb_pos_y;                      // 4

    /* either intra mb or inter mb */
    union {
        struct {
            /* mb scan order */
            char LPredMode[24];                 // 16
            unsigned char CPredMode;            // 1
            /* MbMode of surrounding MB */
            char SurMbMode[2];                  // 2
        } intra;
        
        struct {
            /* raster scan order */
            short int MVx[16];                  // 32
            short int MVy[16];                  // 32
        } inter;
    };

    /* Residual patterns */
    unsigned char   CodedBlockPatternLuma;      // 1
    unsigned char   CodedBlockPatternChroma;    // 1
    
    char padding[18];                           // 18
} mb_fifo_global_t;                          // Total : 94 (to have 96 bytes...!)

/* structure sent by slice thread to idct thread through fifomwmr, 
 * only if CodedBlockPatternLuma > 0 or INTRA_16x16 
 */
typedef struct {
    /* residual */
    short int LumaACLevel[16][16];              // 512
} mb_fifo_luma_t;                            // Total : 512

/* structure sent by slice thread to idct thread through fifomwmr, 
 * only if CodedBlockPatternChroma > 0
 */
typedef struct {
    /* residual */
    short int ChromaACLevel[2][4][16];          // 256
} mb_fifo_chroma_t;                          // Total : 256

void Fill_PSkip(mb_fifo_global_t *mb_fifo_G, char MbMode, int Mvx, int MVy);

void Fill_Inter(mb_fifo_global_t *mb_fifo_G, mode_pred_inf_t *mpi,  char MbMode, unsigned char MbPartPredMode);

void Fill_Intra(mb_fifo_global_t *mb_fifo_G, mode_pred_inf_t *mpi,  char MbMode, unsigned char MbPartPredMode);

void Fill_CodedPattern(mb_fifo_global_t *mb_fifo_G, unsigned char CodedBlockPatternLuma, unsigned char CodedBlockPatternChroma);

#endif
