/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#ifndef _MODEPREDINFO_H
#define _MODEPREDINFO_H

#include <srl.h>

#include "h264.h"

#define MV_NA   0x7F7F

#define MB_1LINE        1
#define CHROMA_1LINE    2
#define TB_1LINE        4

#define MB_2LINE        (2*MB_1LINE)
#define CHROMA_2LINE    (2*CHROMA_1LINE)
#define TB_2LINE        (2*TB_1LINE)

typedef struct {
  /* per-macroblock infrmation     (16x16) */
  char MbMode[MB_2LINE*MBLOCKS_X];                      // 2*22
  
  /* per-chroma block infrmation    (8x8 = 4 x 4x4) */
  unsigned char TotalCoeffC[2][CHROMA_2LINE*CBLOCKS_X]; // 2*4*44
  
  /* per-transform block infrmation (4x4) */
  unsigned char TotalCoeffL[TB_2LINE*TBLOCKS_X];        // 8*88
  char Intra4x4PredMode[TB_2LINE*TBLOCKS_X];            // 8*88
  short int MVx[TB_2LINE*TBLOCKS_X];                    // 8*88 (*2 because short int)
  short int MVy[TB_2LINE*TBLOCKS_X];                    // 8*88 (*2 because short int)

} mode_pred_inf_t;  // total : 44 + 352 + 704 + 704 + 1408 + 1408 = 4620

#define ModePredInfo_MbMode(mpi,x,y)            ((mpi)->MbMode[((y)%MB_2LINE)*MBLOCKS_X+(x)])
#define ModePredInfo_TotalCoeffC(mpi,x,y,iCbCr) ((mpi)->TotalCoeffC[iCbCr][((y)%CHROMA_2LINE)*CBLOCKS_X+(x)])
#define ModePredInfo_TotalCoeffL(mpi,x,y)       ((mpi)->TotalCoeffL[((y)%TB_2LINE)*TBLOCKS_X+(x)])
#define ModePredInfo_Intra4x4PredMode(mpi,x,y)  ((mpi)->Intra4x4PredMode[((y)%TB_2LINE)*TBLOCKS_X+(x)])
#define ModePredInfo_MVx(mpi,x,y)               ((mpi)->MVx[((y)%TB_2LINE)*TBLOCKS_X+(x)])
#define ModePredInfo_MVy(mpi,x,y)               ((mpi)->MVy[((y)%TB_2LINE)*TBLOCKS_X+(x)])

void clear_half_mode_pred_info  (mode_pred_inf_t *mpi, int line);

int get_mb_mode                 (mode_pred_inf_t *mpi, int mb_x, int mb_y);

int get_luma_nC                 (mode_pred_inf_t *mpi, int x, int y);
int get_chroma_nC               (mode_pred_inf_t *mpi, int x, int y, int iCbCr);

int get_Intra4x4PredModeN       (mode_pred_inf_t *mpi, int x, int y);
int get_predIntra4x4PredMode    (mode_pred_inf_t *mpi, int x, int y);

void DeriveMVs                  (mode_pred_inf_t *mpi, int org_x, int org_y, 
                                    int width, int height, int mvdx, int mvdy);
void Derive_P_Skip_MVs          (mode_pred_inf_t *mpi, int org_x, int org_y);

#endif
