/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#ifndef PLANE_POOL_H
#define PLANE_POOL_H

#include <srl.h>
#include "render.h"

typedef struct {
    unsigned int    current_frame;
    frame_t         planes[NB_PLANE_BUFFERS];
} plane_pool_t;

void init_plane_pool(plane_pool_t *plane_pool, void *plane_buffers);
void get_plane_pool(plane_pool_t *plane_pool, unsigned int pic_count, frame_t *frame[2]);
void next_plane_pool(plane_pool_t *plane_pool);
#endif
