/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#ifndef UTILS_H
#define UTILS_H

/*
 * For the DSX's timer feature
 */
#define TIMER_ENABLE(addr)              \
    if ((addr)) {                       \
        *((addr)+1) = 0x1;              \
    }
    
#define TIMER_CYCLE(addr)  \
    ((addr)) ? *(addr) : 0
    
#define TIMER_PRINT(addr, old_val)                          \
    do {                                                    \
    int new_val = TIMER_CYCLE((addr));       \
    srl_log_printf(TRACE, "Elapsed = %d\n",    \
        new_val - (old_val));          \
    (old_val) = new_val;                                      \
    } while(0)

#define TIMER_PRINT_AVE(addr, old_val)                          \
    do {                                                    \
    int new_val = TIMER_CYCLE((addr));       \
    srl_log_printf(TRACE, "Elapsed = %d\n",    \
        new_val - (old_val));          \
    moy_timer += new_val - (old_val);   \
    (old_val) = new_val;                                      \
    } while(0)

/* for debug */
#define MB_FIFO_PRINT\
    do {\
        srl_log_printf(NONE, "analyse macroblock (%d, %d):\n", mb_fifo_G.mb_pos_x, mb_fifo_G.mb_pos_y);\
        srl_log_printf(NONE, "\tMbMode = %d ; MbPartPredMode = %d\n", mb_fifo_G.MbMode, mb_fifo_G.MbPartPredMode);\
        if (mb_fifo_G.MbPartPredMode == Intra_4x4)\
        {\
            int luma4x4BlkIdx;\
            srl_log_printf(NONE, "\tintra_4x4: ");\
            for(luma4x4BlkIdx=0; luma4x4BlkIdx<16; ++luma4x4BlkIdx)\
                srl_log_printf(NONE, "%d ",  mb_fifo_G.intra.LPredMode[luma4x4BlkIdx]);\
            srl_log_printf(NONE, "\n");\
            srl_log_printf(NONE, "\tintra_chroma_pred_mode : %d\n", mb_fifo_G.intra.CPredMode);\
        } \
        else if (mb_fifo_G.MbPartPredMode == Intra_16x16)\
        {\
            srl_log_printf(NONE, "\tintra_16x16: %d\n", mb_fifo_G.intra.LPredMode[0]);\
            srl_log_printf(NONE, "\tintra_chroma_pred_mode : %d\n", mb_fifo_G.intra.CPredMode);\
        }\
        else\
        {\
            int i;\
            srl_log_printf(NONE, "\tinter_MVx: ");\
            for (i=0; i<16; i++)\
                srl_log_printf(NONE, "%d ",  mb_fifo_G.inter.MVx[i]);\
            srl_log_printf(NONE, "\n");\
            srl_log_printf(NONE, "\tinter_MVy: ");\
            for (i=0; i<16; i++)\
                srl_log_printf(NONE, "%d ",  mb_fifo_G.inter.MVy[i]);\
            srl_log_printf(NONE, "\n");\
        }\
        srl_log_printf(NONE, "\tcoded_block_pattern_luma=%d\n", mb_fifo_G.CodedBlockPatternLuma);\
        srl_log_printf(NONE, "\tcoded_block_pattern_chroma=%d\n", mb_fifo_G.CodedBlockPatternChroma);\
        \
        if(mb_fifo_G.CodedBlockPatternLuma>0 || mb_fifo_G.CodedBlockPatternChroma>0 ||\
           mb_fifo_G.MbPartPredMode==Intra_16x16)\
        {\
            int i, i8x8;\
            srl_log_printf(NONE, "\tQPy=%d; QPc=%d\n", mb_fifo_G.QPy, mb_fifo_G.QPc);\
            \
            srl_log_printf(NONE, "\tL:"); \
            for(i=0; i<16; ++i) \
                srl_log_printf(NONE, " %d", mb_fifo_L.LumaDCLevel[i]); \
            srl_log_printf(NONE, "\n");\
            for(i8x8=0; i8x8<16; ++i8x8) { \
                srl_log_printf(NONE, "\t\t[%2d]",i8x8);\
                for(i=0; i<16; ++i) \
                    srl_log_printf(NONE, " %d", mb_fifo_L.LumaACLevel[i8x8][i]); \
                srl_log_printf(NONE, "\n"); \
            }\
            srl_log_printf(NONE, "\tCb:"); \
            for(i=0; i<4; ++i) \
                srl_log_printf(NONE, " %d", mb_fifo_C.ChromaDCLevel[0][i]); \
            srl_log_printf(NONE, "\n");\
            for(i8x8=0; i8x8<4; ++i8x8) { \
                srl_log_printf(NONE, "\t\t[%d]",i8x8);\
                for(i=0; i<16; ++i) \
                    srl_log_printf(NONE, " %d", mb_fifo_C.ChromaACLevel[0][i8x8][i]); \
                srl_log_printf(NONE, "\n"); \
            }\
            srl_log_printf(NONE, "\tCr:"); \
            for(i=0; i<4; ++i) \
                srl_log_printf(NONE, " %d", mb_fifo_C.ChromaDCLevel[1][i]); \
            srl_log_printf(NONE, "\n");\
            for(i8x8=0; i8x8<4; ++i8x8) { \
                srl_log_printf(NONE, "\t\t[%d]",i8x8);\
                for(i=0; i<16; ++i) \
                    srl_log_printf(NONE, " %d", mb_fifo_C.ChromaACLevel[1][i8x8][i]); \
                srl_log_printf(NONE, "\n"); \
            }\
        }\
        srl_log_printf(NONE, "\n");\
    }while(0)


#define LUMA_PRINT \
    do {\
        int i,j;\
        srl_log_printf(NONE, "L :\n");\
        for(j=0; j<16; j++){\
            srl_log_printf(NONE, "\t[%2d] ", j);\
            for(i=0; i<16; i++){\
                srl_log_printf(NONE, "%d ", LumaBuffer[MBLOCK_WIDTH*j + i]);\
            }\
            srl_log_printf(NONE, "\n");\
        }\
    }while(0)

#define CHROMA_PRINT \
    do { \
        int i,j;\
        srl_log_printf(NONE, "%s :\n", iCbCr==0?"Cb":"Cr");\
        for(j=0; j<8; j++){\
            srl_log_printf(NONE, "\t[%2d] ", j);\
            for(i=0; i<8; i++){\
                srl_log_printf(NONE, "%d ", ChromaBuffer[CBLOCK_WIDTH*j + i]);\
            }\
            srl_log_printf(NONE, "\n");\
        }\
    }while(0)
#endif
