/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#ifndef BITSTREAM_IO_H
#define BITSTREAM_IO_H

#include <srl.h>

/*
 * Block_io (used by Nal_unit API)
 */

#define BLOCK_IO_IN     0
#define BLOCK_IO_OUT    1

typedef struct {
    unsigned int  type;
    unsigned int  size;
    unsigned int  left;
    unsigned char *ptr;
    unsigned char *buffer;
    srl_mwmr_t    io;
} block_io_t;
 
 
/*
 * Nal Unit (used by thread_slice_demux for extracting nal unit from bitstream)
 */
 
typedef struct {
    block_io_t      block;
    unsigned int    current;
} nal_unit_t;

void            nal_unit_init_in    ( nal_unit_t *nal, void *buffer, 
                                      int size, srl_mwmr_t mwmr );
void            nal_unit_get_next   ( nal_unit_t *nal );
unsigned char   nal_unit_read_char  ( void *io );
unsigned char   nal_unit_isend      ( nal_unit_t *nal );


/*
 * Slice (used by thread_slice_demux for constructing slice and then
 *        by thread_decode for reading slice)
 */

#define SLICE_IN     0
#define SLICE_OUT    1

typedef struct {
    srl_mwmr_t      io;
    unsigned char   buffer[256];
    unsigned char   type;
    unsigned char   index;
} slice_t;

/* for thread_slice_demux */
void slice_init_out     ( slice_t *slice, srl_mwmr_t mwmr );
void slice_write_char   ( slice_t *slice, unsigned char val );
void slice_end          ( slice_t *slice);

/* for thread_decode */
void            slice_init_in   ( slice_t *slice, srl_mwmr_t mwmr );
unsigned char   slice_read_char ( void *io );
unsigned char   slice_isover    ( slice_t *slice );
void            slice_begin     ( slice_t *slice );

 
/*
 * Bitreader (used by thread_slice_demux over NAL_Unit API and 
 *            by thread_decode over Slice API, to read bit by bit)
 */

typedef struct {
    void            *io;
    unsigned char   (*read_char)(void *);
    unsigned char   current;
    unsigned char   available;
} bitreader_t;

void bitreader_init ( bitreader_t *bitreader, void *io, unsigned char (*read_char)(void *) );

unsigned long bitreader_get     ( bitreader_t *bitreader, int number );
unsigned char bitreader_get_one ( bitreader_t *bitreader );

int bitreader_get_ugolomb   ( bitreader_t *bitreader );
int bitreader_get_sgolomb   ( bitreader_t *bitreader );

void bitreader_refill ( bitreader_t *bitreader );
unsigned char bitreader_isover ( bitreader_t *bitreader );

#endif
