#!/usr/bin/env python
from dsx import *

from config import config
import tasks

# create a pipeline
def pipeline (n, input, output, valid_output, barrier, plane_buffers, plane_pool, parameter_set):
    return (
        Task('thread_decode%d'%n, 'decode',
            {
                'input'         : input,
                'output'        : output,
                'valid_output'  : valid_output,
                'plane_buffers' : plane_buffers,
                'plane_pool'    : plane_pool,
                'parameter_set' : parameter_set,
                'barrier'       : barrier,
                'pipe_id'       : n
		    },
            defines = 
            {
                'SLICE_WIDTH'       : str(tasks.demux_decode_width),
                'OUT_FIFO_WIDTH'    : str(tasks.decode_merge_width),
                'VIDEO_WIDTH'       : str(config.width),
                'VIDEO_HEIGHT'      : str(config.height),
                'VIDEO_FRAMES'      : str(config.frames),
                'NB_PLANE_BUFFERS'  : str(tasks.nb_plane_buffers)
            }
            ),
        )

tcg_tasks = ()

# barrier
barrier = Barrier( 'barrier' )

# Memspaces declarations : Memspace ( 'name', bytes_size )
plane_buffers  = Memspace ( 'plane_buffers', tasks.plane_buffers_size )
plane_pool     = Memspace ( 'plane_pool', tasks.plane_pool_size )
parameter_set  = Memspace ( 'parameter_set', tasks.parameter_set_size )

fb_memspace    = Memspace ( 'fb_memsp', tasks.framebuffer_size )

# Mwmr declarations : Mwmr ( 'name', bytes_width, depth )
tg264_demux = Mwmr ( 'tg_demux', tasks.tg264_demux_width , 10 )

demux_map = { 'input' : tg264_demux, 'parameter_set' : parameter_set }
merge_map = { 'fb_mem_space' : fb_memspace }

# build the pipeline
for i in range(config.pipes):
    demux_decode = Mwmr ( 'demux_decode%d'%i, tasks.demux_decode_width, 5 )
    demux_map['output%d'%i] = demux_decode
    
    decode_merge = Mwmr ( 'decode_merge%d'%i, tasks.decode_merge_width, 6*11 )
    merge_map['input%d'%i] = decode_merge

    valid_decode_merge = Mwmr ( 'valid_decode_merge%d'%i , 4, 1*11 )
    merge_map['valid_input%d'%i] = valid_decode_merge

    tcg_tasks += pipeline ( i, demux_decode, decode_merge, valid_decode_merge,
                            barrier, plane_buffers, plane_pool, parameter_set )
    

# TCG declaration
tcg_tasks += (
    Task(   'tg264', 
            'tg264',
            {
                'output'    : tg264_demux
            },
            defines = 
            {
                'FILE_NAME'         : '"%s"'%config.file,
                'OUT_FIFO_WIDTH'    : str(tasks.tg264_demux_width)
            }
        ),
        
    Task(   'demux', 
            'demux',
            demux_map,
            defines = 
            {
                'IN_FIFO_WIDTH'     : str(tasks.tg264_demux_width),
                'SLICE_WIDTH'       : str(tasks.demux_decode_width),
                'VIDEO_WIDTH'       : str(config.width),
                'VIDEO_HEIGHT'      : str(config.height),
                'NB_PIPES'          : str(config.pipes)
            }
        ),

    Task(   'merge', 
            'merge',
            merge_map,
            defines = 
            {
                'IN_FIFO_WIDTH'     : str(tasks.decode_merge_width),
                'VIDEO_WIDTH'       : str(config.width),
                'VIDEO_HEIGHT'      : str(config.height),
                'NB_PIPES'          : str(config.pipes),
            }
        ),
    )

tcg = Tcg(*tcg_tasks)

if __name__ == '__main__':
	tcg.generate(Posix())
	
