/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#ifndef PARAMETER_SET_H
#define PARAMETER_SET_H

#include <srl.h>
#include "bitstream_io.h"

typedef struct {
    unsigned char profile_idc;
    unsigned char level_idc;
    unsigned char seq_parameter_set_id;
    unsigned char log2_max_frame_num;
    unsigned char pic_order_cnt_type;
    unsigned char log2_max_pic_order_cnt_lsb;
    unsigned char num_ref_frames;
    unsigned char PicWidthInMbs;
    unsigned char PicHeightInMbs;
    unsigned char frame_mbs_only_flag;
    unsigned char frame_cropping_flag;
    unsigned char vui_parameters_present_flag;
} sps_t; // size = 12 bytes => 12 bytes

typedef struct {
    unsigned char pic_parameter_set_id;
    unsigned char seq_parameter_set_id;
    unsigned char entropy_coding_mode_flag;
    unsigned char pic_order_present_flag;
    unsigned char num_slice_groups;
    unsigned char num_ref_idx_l0_active;
    unsigned char num_ref_idx_l1_active;
    unsigned char weighted_pred_flag;
    unsigned char weighted_bipred_idc;
    char          pic_init_qp;
    char          pic_init_qs;
    char          chroma_qp_index_offset;
    unsigned char deblocking_filter_control_present_flag;
    unsigned char constrained_intra_pred_flag;
    unsigned char redundant_pic_cnt_present_flag;
} pps_t; // size = 15 bytes => 16 bytes

typedef struct {
    sps_t sps;
    pps_t pps;
} ps_t;

void sequence_parameter_set (nal_unit_t *nalu, sps_t *sps);
void picture_parameter_set (nal_unit_t *nalu, pps_t *pps);

#endif
