/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#ifndef _TRANSFORM_H
#define _TRANSFORM_H

typedef struct {
  short int items[16];
} core_block_t;

#define CoreBlock(b,i,j) (b)->items[(j)|((i)<<2)]

#define CombineSign(sign,value) ((sign)?(-(value)):(value))
#define ExtractSign(x) ((x)>>31)

#define DQP0  10,13,10,13, 13,16,13,16
#define DQP1  11,14,11,14, 14,18,14,18
#define DQP2  13,16,13,16, 16,20,16,20
#define DQP3  14,18,14,18, 18,23,18,23
#define DQP4  16,20,16,20, 20,25,20,25
#define DQP5  18,23,18,23, 23,29,23,29

void transform_luma_dc (short int *in, short int *out, int qp);
void transform_luma_ac (short int *scan, int qp, int without_dc);

void transform_chroma_dc (short int *in, short int *out, int qp);
#define transform_chroma_ac transform_luma_ac

#endif
