#!/usr/bin/env python
import soclib

from config import config
import tasks

def FlatMulti(
        nb_decode_cpu = 1,
        width = 176,
        height = 144,
        with_gdb = False,
        with_memchecker = False,
        with_profiler = False,
        min_latency = 10,
        icache_ways = 1,
        icache_sets = 8,
        icache_words = 4,
        dcache_ways = 1,
        dcache_sets = 8,
        dcache_words = 4,
        ):

    arch = soclib.Architecture(
            cell_size = 4,
            plen_size = 6,
            addr_size = 32,
            rerror_size = 1,
            clen_size = 1,
            rflag_size = 1,
            srcid_size = 8,
            pktid_size = 1,
            trdid_size = 1,
            wrplen_size = 1
            )

    arch.cpu = []

    arch.create('common:mapping_table',
            'mapping_table',
            addr_bits = [8],
            srcid_bits = [8],
            cacheability_mask = 0x00200000)
    arch.create('common:loader', 'loader')

    vgmn = arch.create('caba:vci_vgmn', 'vgmn0', min_latency = min_latency, fifo_depth = 8)

    # loop for creating decoding cpu(s)
    for i in range(nb_decode_cpu + 2):
        add = dict(iss_t='common:mips32el')
        toreplace = 'iss_t'
        for doit, target_name, wrapper in (
                (with_memchecker, 'iss_memchecker_t', 'common:iss_memchecker'),
                (with_gdb, 'gdb_iss_t', 'common:gdb_iss'),
                (with_profiler, 'profiler_iss_t', 'common:iss2_profiler'),
                ):
            if doit:
                add[target_name] = add[toreplace]
                add[toreplace] = wrapper
        print add
        xcache = arch.create('caba:vci_xcache_wrapper',
                'mips_%d'%i,
                ident = i,
                icache_ways = icache_ways,
                icache_sets = icache_sets,
                icache_words = icache_words,
                dcache_ways = dcache_ways,
                dcache_sets = dcache_sets,
                dcache_words = dcache_words,
                **add
                )

        vgmn.to_initiator.new() // xcache.vci
        arch.cpu.append(xcache)

    # cached ram in one bank
    ram = arch.create('caba:vci_ram', 'cram')
    ram.addSegment('cram0', 0x40000000, 0x100000, True) # 1Mo
    ram.addSegment('boot',  0xbfc00000, 0x800,    True)
    ram.addSegment('excep', 0x80000080, 0x800,    True)
    ram.vci // vgmn.to_target.new()

    # uncached ram in another bank
    ram = arch.create('caba:vci_ram', 'uram')
    ram.addSegment('uram0', 0x50200000, 0x100000, False) # 1Mo
    ram.vci // vgmn.to_target.new()

    # tg264
    model = tasks.tg264.getImpl(soclib.HwTask)
    ctrl, coproc = model.instanciate(arch, 'tg264_0', 'tg264_0_ctrl',
            defines = {'FILE_NAME':'"%s"'%config.file, 'OUT_FIFO_WIDTH':str(tasks.tg264_demux_width)})
    ctrl.addSegment('tg264_0_ctrl', 0x70200000, 0x200, False)
    ctrl.vci_initiator // vgmn.to_initiator.new()
    ctrl.vci_target // vgmn.to_target.new()

    # tty
    arch.ntty = len(arch.cpu)
    tty = arch.create('caba:vci_multi_tty', 'tty', names = map(lambda x:'tty%d'%x, range(arch.ntty)))
    tty.addSegment('tty', 0x95200000, 0x10*arch.ntty, False)
    tty.vci // vgmn.to_target.new()

    # framebuffer
    fb = arch.create('caba:vci_framebuffer', 'fb', width=width, height=height)
    fb.addSegment('fb0', 0x30200000, 2*(width*height), False)
    fb.vci // vgmn.to_target.new()

    # timer
    timer = arch.create('caba:vci_timer', 'timer_h264', nirq=1)
    timer.addSegment('timer0', 0xb0200000, 0x10, False)
    timer.vci // vgmn.to_target.new()

    return arch
