#!/usr/bin/env python
from dsx import *
from soclib import *

from app import *
from arch import *

# Get all the types of Nodes
all_mwmr        = tcg.nodesOfType('mwmr')
all_barriers    = tcg.nodesOfType('barrier')
all_memspace    = tcg.nodesOfType('memspace')

###
### Hardware instanciation
###

# Define the hard platform according to the settings
hard = FlatMulti(config.pipes, config.width, config.height, with_gdb=True, with_memchecker=False)

###
### Now the mapping part
###

# Create a mapper
mapper = Mapper( hard, tcg )

# Fifos
for fifo in all_mwmr:
    mapper.map( fifo,
                buffer  = 'cram0',
                status  = 'cram0',
                desc    = 'cram0' )

# Barriers
for barrier in all_barriers:
    mapper.map( barrier,
                buffer  = 'cram0',
                status  = 'cram0',
                desc    = 'cram0' )

# Memspaces
for mem in all_memspace:
    if 'fb' in mem.name:
        mapper.map(  mem,
                buffer  = 'fb0',
                desc    = 'cram0' )
    else:
        mapper.map( mem,
                buffer  = 'uram0',
                desc    = 'cram0' )

# Decode threads
for cpu_num in range(config.pipes):
    mapper.map( tcg['thread_decode%d'%cpu_num],
            desc    = 'cram0',
            stack   = 'cram0',
            run     = 'mips_%d'%(cpu_num+2),
            tty     = 'tty',
            tty_no  = cpu_num)
# Demux and Merge threads
mapper.map( mapper.tcg['demux'],
        desc    = 'cram0',
        stack   = 'cram0',
        run     = 'mips_0',
        tty     = 'tty',
        tty_no  = config.pipes)
mapper.map( mapper.tcg['merge'],
        desc    = 'cram0',
        stack   = 'cram0',
        run     = 'mips_1',
        tty     = 'tty',
        tty_no  = config.pipes+1)

# Hardware copro for tg264
mapper.map ('tg264', coprocessor = 'tg264_0', controller = 'tg264_0_ctrl')

# Define where CPU objects goes
ntty = 0
for c in hard.cpu:
    mapper.map(mapper.hard[c.instName()],
            shared  = 'uram0',
            private = 'cram0',
            tty     = 'tty',
            tty_no  = ntty)
    ntty += 1

# And system objects, and executable code
mapper.map(mapper.tcg,
        shared  = 'uram0',
        code    = 'cram0',
        private = 'cram0',
        tty     = 'tty',
        tty_no  = 0)

###
### Source generation
###

# We have everything ready, let's generate sources
mapper.generate(
        MutekS ( 
            outdir='muteks%d'%config.pipes,
            verbosity='TRACE',
            with_stream = True,
            #CONFIG_COMPILE_DEBUG = True,
            #CONFIG_COMPILE_OPTIMIZE=0
            )
        )

