/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#ifndef _DEC_BITSTREAM_H
#define _DEC_BITSTREAM_H

#include <srl.h>
#include "h264.h"
#include "bitstream_io.h"
#include "parameter_set.h"

/***********************/
/* Decode Slice Header */
/***********************/

/* NAL infos */
typedef struct {
    unsigned char ref_idc;
    unsigned char type;
} nal_inf_t;

/* SLICE infos */
typedef struct {
    unsigned int    first_mb;
    unsigned int    frame_num;
    unsigned int    pic_order_cnt_lsb;
    int             qp_delta;
    int             QPy;
    unsigned char   type;
} slice_inf_t;

void decode_slice_header (  slice_inf_t *slice_inf, 
                            nal_inf_t *nal_inf, 
                            bitreader_t *bits,
                            ps_t *ps);

/***********************/
/* Decode MB Modes     */
/***********************/

/* Macroblock mode */
typedef struct {
    char mb_type;
    char NumMbPart;
    char MbPartPredMode[2];
    char Intra16x16PredMode;
    char MbPartWidth;
    char MbPartHeight;
    char CodedBlockPatternChroma;
    char CodedBlockPatternLuma;
} mb_mode_t;

/* Sub-macroblock mode */
typedef struct {
    char sub_mb_type;
    char NumSubMbPart;
    char SubMbPredMode;
    char SubMbPartWidth;
    char SubMbPartHeight;
} sub_mb_mode_t;

void decode_mb_mode     ( mb_mode_t *mb, 
                            int slice_type, int raw_mb_type );

void decode_sub_mb_mode ( sub_mb_mode_t *sub, 
                            int slice_type, int raw_sub_mb_type );

/***********************/
/* Decode Residual     */
/***********************/

typedef struct {
    unsigned int code;
    int nbbits;
    int data;
} code_item_t;

int residual_block ( short int *coeffLevel, 
                     int maxNumCoeff, 
                     int nC, 
                     bitreader_t *bits );

#endif
