/* This file is part of DSX.
 *
 * DSX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DSX is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DSX; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Copyright (c) Lip6, Thalès
 *      Joel Porquet <joel.porquet@lip6.fr>, 2006-2007
 *
 * Based on Martin Fielder's work (http://keyj.s2000.ws/?page_id=41)
 */

#include <stdio.h>
#include <srl.h>
#include "tg264_proto.h"

static FILE *fi;

FUNC(bootstrap)
{
    fi = fopen(FILE_NAME, "r");
    if ( ! fi ) {
        perror("fopen("FILE_NAME")");
        exit(1);
    }

    srl_mwmr_config(tg_ctrl, 0, 1);
}

FUNC(tg264)
{
    srl_log(TRACE, "TG264 up and running...\n");
    srl_mwmr_t output = GET_ARG(output);
    unsigned char e[OUT_FIFO_WIDTH];

    while(1)
    {
        int r;
        r = fread(e, 1, OUT_FIFO_WIDTH, fi);
        if ( r < OUT_FIFO_WIDTH ) 
        {
            fseek(fi, 0, SEEK_SET );
            fread(e+r, 1, OUT_FIFO_WIDTH-r, fi);
        }
        srl_mwmr_write(output, e, OUT_FIFO_WIDTH);

        if (feof(fi)!=0) 
        {
            srl_log(NONE, "EOF");
            fclose(fi);
            return;
        }
    }
}

