/*
 * hal_irqmask.c - implementation of Generic IRQ Masking API for x86
 *
 * Copyright (c) 2017 Maxime Villard
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH.; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <hal_internal.h>

static int interrupts_enabled __in_kdata = 0;

inline void hal_disable_irq(uint32_t *old)
{
	if (!interrupts_enabled) {
		x86_panic("nested critical sections forbidden");
	}
	interrupts_enabled = 0;
	cli();
}

inline void hal_enable_irq(uint32_t *old)
{
	if (interrupts_enabled) {
		x86_panic("nested critical sections forbidden");
	}
	interrupts_enabled = 1;
	sti();
}

inline void hal_restore_irq(uint32_t old)
{
	x86_panic((char *)__func__);
}

