/*
 * hal_ppm.c - Generic Physical Page Manager API implementation for x86
 *
 * Copyright (c) 2017 Maxime Villard
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH.; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <kernel_config.h>
#include <hal_types.h>
#include <hal_ppm.h>
#include <hal_special.h>
#include <printk.h>
#include <spinlock.h>
#include <process.h>
#include <ppm.h>
#include <thread.h>
#include <cluster.h>
#include <page.h>

#include <hal_internal.h>

error_t hal_ppm_init(boot_info_t *info)
{
	size_t i;

	// get relevant info from boot_info structure
	uint32_t pages_nr         = info->pages_nr;
	uint32_t pages_tbl_offset = info->pages_offset;
	uint32_t rsvd_nr          = info->rsvd_nr;

	// get pointer on local Physical Page Manager
	ppm_t * ppm = &LOCAL_CLUSTER->ppm;

	// initialize lock protecting the free_pages[] lists
	spinlock_init( &ppm->free_lock );

	// initialize lock protecting the dirty_pages list
	spinlock_init( &ppm->dirty_lock );

	// initialize all free_pages[] lists as empty
	for( i = 0 ; i < CONFIG_PPM_MAX_ORDER ; i++ )
	{
		list_root_init( &ppm->free_pages_root[i] );
		ppm->free_pages_nr[i] = 0;
	}

	// TODO

	x86_panic((char *)__func__);
	return 0;
}

