/*
 * hal_exception.c - implementation of exception handler for TSAR-MIPS32.
 * 
 * Author   Alain Greiner (2016, 2017)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <hal_irqmask.h>
#include <hal_exception.h>
#include <thread.h>
#include <printk.h>
#include <vmm.h>
#include <errno.h>
#include <scheduler.h>
#include <core.h>
#include <signal.h>
#include <syscalls.h>
#include <do_exception.h>
#include <remote_spinlock.h>

#include <hal_internal.h>

void hal_do_exception( thread_t * this, 
                       reg_t    * regs_tbl )
{
	x86_panic((char *)__func__);
}

void hal_exception_dump( thread_t * this,
                         reg_t    * regs_tbl )
{
	x86_panic((char *)__func__);
}

