/*
 * sys_trace.c - show kernel active processes and threads
 * 
 * Author    Alain Greiner (c) (2016,2017)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <hal_special.h>
#include <printk.h>
#include <thread.h>
#include <errno.h>
#include <syscalls.h>

//////////////////////////////////
int sys_trace( uint32_t operation,
               pid_t    pid, 
               uint32_t trdid )
{
    // get extended pointer on target thread
    xptr_t thread_xp = thread_get_xptr( pid , trdid );

    if( thread_xp == XPTR_NULL )
    {
        printk("\n[ERROR] in %s : undefined thread for PID = %x / TRDID = %x\n",
               __FUNCTION__ , pid , trdid );
        CURRENT_THREAD->errno = EINVAL;
        return -1;
    }

    if( operation == TRACE_OFF )
    {
        // desactivate thread trace TODO

	    printk("\n[INFO] %s : trace OFF  for thread %x in process %x\n",
               __FUNCTION__ , trdid , pid );
    }
    else if( operation == TRACE_ON )
    {
        // activate thread trace TODO
		    
	    printk("\n[INFO] %s : trace ON for thread %x in process %x\n",
               __FUNCTION__ , trdid , pid );
    }
    else
    {
        printk("\n[ERROR] in %s : undefined operation\n", __FUNCTION__ );
        CURRENT_THREAD->errno = EINVAL;
        return -1;
    }

    hal_wbflush();

    return 0;

}  // end sys_trace()
