/*
 * remote.c  - implementation of remote access HAL for x86 64 bits
 * 
 * Authors : Mohammed Karaoui / Alain Greiner (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-kernel.
 *
 * ALMOS-kernel is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-kernel is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-kernel; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#if !defined( RUN_IN_PHYSICAL_MODE ) 
#error: You must define RUN_IN_PHYSICAL_MODE in arch_config.h file
#endif

#if ( RUN_IN_PHYSICAL_MODE != yes ) 
#error: RUN_IN_PHYSICAL_MODE in arch_config.h file must be no
#endif



//////////////////////////////////////
inline void cpu_remote_sb( xptr_t  xp,
                       char    data )
{
   char * ptr = (char *)xp;
   *ptr       = data;
}

////////////////////////////////////////
inline void cpu_remote_sw( xptr_t    xp,
                       uint32_t  data )
{
   uint32_t * ptr = (uint32_t *)xp;
   *ptr           = data;
}

/////////////////////////////////////////
inline void cpu_remote_swd( xptr_t    xp,
                        uint64_t  data )
{
   uint64_t * ptr = (uint64_t *)xp;
   *ptr           = data;
}

//////////////////////////////////////
inline char cpu_remote_lb( xptr_t xp )
{
   char * ptr = (char *)xp;
   return *ptr;
}

//////////////////////////////////////////
inline uint32_t cpu_remote_lw( xptr_t xp )
{
   uint32_t * ptr = (uint32_t *)xp;
   return *ptr;
}

///////////////////////////////////////////
inline uint64_t cpu_remote_lwd( xptr_t xp )
{
   uint64_t * ptr = (uint64_t *)xp;
   return *ptr;
}

//////////////////////////////////////////////
inline uint32_t cpu_remote_lw_unc( xptr_t xp )
{
    // TODO not implemented
    printk("cpu_remote_lw_unc() function not implemented for x86\n");
}

/////////////////////////////////////////////////
inline bool_t cpu_remote_atomic_cas( xptr_t   xp, 
                                     uint32_t old,
                                     uint32_t new )
{
    // TODO not implemented
    printk("cpu_remote_atomic_cas() function not implemented for x86\n");
}

///////////////////////////////////////////////
inline uint32_t cpu_remote_atomic_add( xptr_t   xp,
                                       uint32_t incr )
{	
    // TODO not implemented
    printk("cpu_remote_atomic_add() function not implemented for x86\n");
}

////////////////////////////////////////////////////
inline error_t cpu_remote_atomic_try_add( xptr_t     xp,
                                          uint32_t * old )
{
    // TODO not implemented
    printk("cpu_remote_atomic_try_add() function not implemented for x86\n");
}

////////////////////////////////////////
inline void * cpu_remote_memcpy( xptr_t   dst,
                                 xptr_t   src,
                                 size_t   size )
{
   void * dst_ptr = (void *)dst;
   void * src_ptr = (void *)src;
   return memcpy( dst_ptr , src_ptr , size );
}


