/*
 * hal_irqmask.c - implementation of Generic IRQ Masking API for x86
 *
 * Copyright (c) 2017 Maxime Villard
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH.; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <hal_internal.h>

#define INTRS_ENABLED	0xFFEFAAAA
#define INTRS_DISABLED	0xD0CCCCC0

static uint32_t intrs_state __in_kdata = INTRS_DISABLED;

inline void hal_disable_irq(uint32_t *old)
{
	*old = intrs_state;
	intrs_state = INTRS_DISABLED;
	cli();
}

inline void hal_enable_irq(uint32_t *old)
{
	*old = intrs_state;
	intrs_state = INTRS_ENABLED;
	sti();
}

inline void hal_restore_irq(uint32_t old)
{
	intrs_state = old;

	if (intrs_state == INTRS_ENABLED)
		sti();
	else if(intrs_state == INTRS_DISABLED)
		cli();
	else
		x86_panic("hal_restore_irq: not reachable");
}

