/*
 * hal_drivers.c - Driver initializers for x86_64
 *
 * Copyright (c) 2017 Maxime Villard
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <chdev.h>
#include <hal_drivers.h>
#include <hal_internal.h>

#include <ioc_ata.h>
#include <pic_apic.h>
#include <txt_rs232.h>

void hal_drivers_txt_init(chdev_t *txt, uint32_t impl)
{
	txt_rs232_init(txt);
}

/* -------------------------------------------------------------------------- */

void hal_drivers_pic_init(chdev_t *pic)
{
	pic_apic_init(pic);

	/* update the PIC chdev extension */
	pic->ext.pic.enable_timer = &pic_apic_enable_timer;
	pic->ext.pic.enable_irq   = &pic_apic_enable_irq;
	pic->ext.pic.disable_irq  = &pic_apic_disable_irq;
	pic->ext.pic.bind_irq     = &pic_apic_bind_irq;
	pic->ext.pic.send_ipi     = &pic_apic_send_ipi;
	pic->ext.pic.extend_init  = &pic_apic_extend_init;
}

/* -------------------------------------------------------------------------- */

void hal_drivers_ioc_init(chdev_t *ioc, uint32_t impl)
{
	ioc_ata_init(ioc);
}

