/*********************************************************************************
 * This file defines various configuration parameters for ALMOS-MKH boot-loader. 
 ********************************************************************************/

#ifndef _BOOT_CONFIG_H
#define _BOOT_CONFIG_H

// Debug options
#define DEBUG_BOOT_INFO     0
#define DEBUG_BOOT_ELF      0
#define DEBUG_BOOT_IOC      0
#define DEBUG_BOOT_WAKUP    0
#define DEBUG_BOOT_FAT32    0

// Core identifier format
#define USE_FIXED_FORMAT    1

// cache line
#define CACHE_LINE_SIZE     64

// Preloader temporary segment
#define PRELOADER_BASE      0x0             /* Preloader base address.      */
#define PRELOADER_MAX_SIZE  0x4000          /* Preloader max size.          */

// boot code temporary segment
#define BOOT_BASE           0x100000        /* 'boot.elf' base address.     */
#define BOOT_MAX_SIZE       0x010000        /* 'boot.elf' max size.         */

// arch_info temporary segment
#define ARCHINFO_BASE       0x200000        /* 'arch_info.bin' file base address */
#define ARCHINFO_MAX_SIZE   0x010000        /* 'arch_info.bin' file max size.    */

// kernel code temporary segment
#define KERN_BASE           0x300000        /* 'kernel.elf' file base address    */
#define KERN_MAX_SIZE       0x200000        /* 'kernel.elf' file max size.       */

// Temporary stacks segments
#define BOOT_STACK_BASE     0x504000        /* Boot stack base address.     */
#define BOOT_STACK_SIZE     0x4000          /* Boot stack size (16Kb)       */

#endif  // _BOOT_CONFIG_H
