/*******************************************************************************
 * This is the linker script for the ALMOS-MKH TSAR kernel.
 * It describes the memory layout for the "kernel.elf" binary file.
 ******************************************************************************/

/* Define the kernel code base address */

seg_kcode_base = 0x00004000;
seg_kgiet_base = 0x80000000;

/* Set the entry point (e_entry field in the "kernel.elf" file header) */

ENTRY(kernel_init)

/* Describe how to group the sections */

SECTIONS
{
	. = seg_kcode_base;
	seg_kcode :
	{
		*(.text)
		*(.rodata*)
	}

	. = ALIGN(0x1000);

	seg_kdata :
	{
		*(.kinfo)
		*(.kidle)
		*(.kdata*)
		*(.data*)
	}

    . = seg_kgiet_base;
    seg_kgiet :
    {
		*(.kgiet)
    }
}
