/*
 * hal_arch.c - General purpose code for x86.
 *
 * Authors   Maxime Villard  (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH.is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH.is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH.; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <errno.h>
#include <types.h>
#include <thread.h>
#include <core.h>
#include <system.h>
#include <kmem.h>
#include <chdev.h>
#include <cluster.h>
#include <soclib_xicu.h>
#include <kdmsg.h>
#include <arch.h>

static void cpu_default_irq_handler(struct irq_action_s *action)
{

}

error_t arch_cpu_init( core_t * core )
{
	return 0;
}

error_t arch_cpu_set_irq_entry( core_t   * core,
                                uint32_t   irq_nr,
                                struct irq_action_s *action )
{
	return 0;
}

error_t arch_cpu_get_irq_entry( core_t   * core,
                                uint32_t   irq_nr,
                                struct irq_action_s **action)
{
	return 0;
}
	
error_t arch_set_power_state( core_t * core,
                              arch_power_state_t state)
{
	return 0;
}

sint_t arch_barrier_init(struct cluster_s *cluster, struct event_s *event, uint_t count)
{
	return 0;
}

sint_t arch_barrier_wait(struct cluster_s *cluster, uint_t barrier_id)
{
	return 0;
}

error_t arch_barrier_destroy(struct cluster_s *cluster, uint_t barrier_id)
{
	return 0;
}

error_t hal_send_ipi( cxy_t    cxy,
                      lid_t    lid, 
                      uint32_t val )
{
	return 0;
}
