/*******************************************************************************
 * This is the linker script for the ALMOS-MKH x86_64 kernel.
 * It describes the memory layout for the "kernel.elf" binary file.
 ******************************************************************************/

__PAGE_SIZE = 0x1000 ;

__KERNEL_BASE_VIRT = 0xffffffff80000000 ;
__KERNEL_BASE_PHYS = 0x0000000000000000 ;

__KERNEL_TEXT_VIRT = 0xffffffff80200000 ;
__KERNEL_TEXT_PHYS = 0x0000000000200000 ;

START_PHYS_ADDR = start_x86_64 - __KERNEL_BASE_VIRT ;

ENTRY(start_x86_64)

SECTIONS
{
	. = __KERNEL_TEXT_VIRT ;

	seg_kcode : AT(__KERNEL_TEXT_PHYS)
	{
		*(.boot)
		*(.text)
		*(.rodata*)
	}

	. = ALIGN(__PAGE_SIZE) ;

	__kernel_data_start = . ;
	seg_kdata :
	{
		*(.kinfo)
		*(.kidle)
		*(.kdata*)
		*(.data*)
		. = ALIGN(__PAGE_SIZE) ;
	}

	__kernel_end = . ;
}

