/*
 * kernel_config.h - global kernel configuration arguments
 * 
 * Authors  Ghassan Almaless (2008,2009,2010,2011,2012) 
 *          Mohamed Lamine Karaoui (2015)
 *          Alain Greiner (2016)
 *
 * Copyright (c)  UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _ALMOS_CONFIG_H_
#define _ALMOS_CONFIG_H_

#define CONFIG_ALMOS_VERSION                "Version 1.0 / March 2017"

////////////////////////////////////////////////////////////////////////////////////////////
//          KERNEL DEBUG 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_CLUSTER_DEBUG          0
#define CONFIG_CONTEXT_DEBUG          0
#define CONFIG_CORE_DEBUG             0
#define CONFIG_DEVFS_DEBUG            1
#define CONFIG_DMA_DEBUG              0
#define CONFIG_DQDT_DEBUG             0
#define CONFIG_ELF_DEBUG              0
#define CONFIG_EXEC_DEBUG             0
#define CONFIG_FATFS_DEBUG            1
#define CONFIG_FBF_DEBUG              0
#define CONFIG_FORK_DEBUG             0
#define CONFIG_IDLE_DEBUG             0
#define CONFIG_IOC_DEBUG              1
#define CONFIG_IRQ_DEBUG              1
#define CONFIG_KCM_DEBUG              0
#define CONFIG_KHM_DEBUG              0
#define CONFIG_KINIT_DEBUG            1
#define CONFIG_KMEM_DEBUG             0
#define CONFIG_MMC_DEBUG              0
#define CONFIG_MAPPER_DEBUG           0 
#define CONFIG_NIC_DEBUG              0
#define CONFIG_PIC_DEBUG              0
#define CONFIG_PPM_DEBUG              0
#define CONFIG_PROCESS_DEBUG          0
#define CONFIG_RPC_DEBUG              1
#define CONFIG_SCHED_DEBUG            0
#define CONFIG_SIGNAL_DEBUG           0
#define CONFIG_SYSCALL_DEBUG          0
#define CONFIG_THREAD_DEBUG           0
#define CONFIG_TXT_DEBUG              0
#define CONFIG_VFS_DEBUG              1
#define CONFIG_VMM_DEBUG              0

////////////////////////////////////////////////////////////////////////////////////////////
//        HARDWARE CONFIGURATION     
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_KERNEL_IDENTITY_MAP          true       // True for 32 bits cores             
#define CONFIG_CYCLES_PER_MS                1000000    // about 1 Ghz             
#define CONFIG_MAX_CLUSTER                  256        // max number of clusters
#define CONFIG_MAX_LOCAL_CORES              4          // max number of cores per cluster
#define CONFIG_MAX_INT_DEV                  4          // max number of internal peripherals
#define CONFIG_MAX_EXT_DEV                  8          // max number of external peripherals
#define CONFIG_MAX_INTERNAL_IRQS            32         // max number of HWI per ICU
#define CONFIG_MAX_EXTERNAL_IRQS            32         // max number of PTI per ICU
#define CONFIG_IRQS_PER_CORE                4          // number of input IRQs per core
#define CONFIG_CLUSTER_SPAN                 32         // ln(phys. address space per cluster)
#define CONFIG_CACHE_LINE_SIZE              64         // number of bytes in cache line

#define CONFIG_CACHE_LINE_ALIGNED           __attribute__((aligned(CONFIG_CACHE_LINE_SIZE)))

#define CONFIG_MAX_IOC_CHANNELS             1          // max number of IOC device channels
#define CONFIG_MAX_FBF_CHANNELS             1          // max number of FBF device channels
#define CONFIG_MAX_TXT_CHANNELS             16         // max number of TXT device channels
#define CONFIG_MAX_DMA_CHANNELS             8          // max number of DMA device channels
#define CONFIG_MAX_NIC_CHANNELS             8          // max number of NIC device channels

#define CONFIG_MAX_CLUSTERS                 256        // max number of clusters

#define CONFIG_TXT_ECHO_MODE                1          // echo mode for TXT peripheral

#define CONFIG_FBF_WIDTH                    128
#define CONFIG_FBF_HEIGHT                   128

#define CONFIG_CPU_CTX_SIZE                 128        // up to 32 uint32_t registers
#define CONFIG_FPU_CTX_SIZE                 256        // up to 32 uint64_t registers
#define CONFIG_NIC_CHBUF_DEPTH              1          // number of containers in NIC chbuf

////////////////////////////////////////////////////////////////////////////////////////////
//      PROCESS MANAGEMENT       
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_MAX_PROCESS_PER_CLUSTER      128        // max number of owned process
#define CONFIG_PROCESS_FILE_MAX_NR          8          // max number of open files
#define CONFIG_PROCESS_MAX_CHILDREN         1024       // max number of children process
#define CONFIG_PROCESS_HEAP_MIN_SIZE        0x00010000 // user heap min size (bytes)
#define CONFIG_PROCESS_HEAP_MAX_SIZE        0x30000000 // user heap max size (bytes)
#define CONFIG_PROCESS_INIT_PATH            "/bin/init/init.elf"

////////////////////////////////////////////////////////////////////////////////////////////
//          VIRTUAL FILE SYSTEM        
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_VFS_MAX_INODES               128        // max number of inodes per cluster
#define CONFIG_VFS_MAX_NAME_LENGTH          32         // dentry name max length (bytes)
#define CONFIG_VFS_MAX_PATH_LENGTH          256        // pathname max length (bytes)
#define CONFIG_VFS_KBUF_SIZE                256        // kernel buffer for read/write

#define CONFIG_VFS_ROOT_IS_FATFS            1          // root FS is FATFS if non zero
#define CONFIG_VFS_ROOT_IS_EX2FS            0          // root FS is EX2FS if non zero

////////////////////////////////////////////////////////////////////////////////////////////
//          MISCELANEOUS        
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_CORE_CHECK_EVERY		        2000
#define CONFIG_DEV_VERSION                  yes
#define CONFIG_USE_COA                      yes
#define CONFIG_EXEC_LOCAL                   no
#define CONFIG_USE_KEYSDB                   yes
#define CONFIG_SHOW_BOOT_BANNER             yes
#define CONFIG_MAX_CLUSTER_ROOT             16
#define CONFIG_GLOBAL_CLUSTERS_ORDER        0
#define CONFIG_GLOBAL_CORES_ORDER           0
#define CONFIG_MAX_DQDT_DEPTH               4
#define CONFIG_USE_DQDT                     no
#define CONFIG_CORE_BALANCING_PERIOD        4
#define CONFIG_CORE_LOAD_PERIOD             4
#define CONFIG_CLUSTER_KEYS_NR              8
#define CONFIG_REL_KFIFO_SIZE               32

////////////////////////////////////////////////////////////////////////////////////////////
//          LOCKS          
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_RWLOCK_DELAY                 50       // iterations number ( ~ 200 cycles )

////////////////////////////////////////////////////////////////////////////////////////////
//          DQDT           
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_DQDT_LEVELS_NR               5
#define CONFIG_DQDT_PERIOD                  1        // number of ticks between updates

////////////////////////////////////////////////////////////////////////////////////////////
//          RANDOM NUMBERS 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_RDNG_PARAM_A                 65519
#define CONFIG_RDNG_PARAM_C                 64037

////////////////////////////////////////////////////////////////////////////////////////////
//          SCHEDULING 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_SCHED_TICK_PERIOD            2000000 // number of cycles
#define CONFIG_SCHED_MAX_THREADS_NR         32      // max number of threads per core

////////////////////////////////////////////////////////////////////////////////////////////
//          THREADS 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_THREAD_MAX_PER_CLUSTER       16      // max user threads per cluster
#define CONFIG_THREAD_DESC_SIZE             0x2000  // thread desc size (with kstack)
#define CONFIG_THREAD_DESC_ORDER            1       // ln( number of 4K pages )

////////////////////////////////////////////////////////////////////////////////////////////
//          REMOTE_FIFO 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_REMOTE_FIFO_SLOTS		    16
#define CONFIG_REMOTE_FIFO_ITERATION_DELAY  1024
#define CONFIG_REMOTE_FIFO_MAX_ITERATIONS   1024

////////////////////////////////////////////////////////////////////////////////////////////
//          REMOTE PROCEDURE CALL
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_RPC_PENDING_MAX              8      // max requests handled by one server 
#define CONFIG_RPC_THREADS_MAX              8      // max number of RPC threads per core

////////////////////////////////////////////////////////////////////////////////////////////
//         USER APPLICATION STDIO
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_DEV_STDIN                    "/dev/external/txt_1"
#define CONFIG_DEV_STDOUT                   "/dev/external/txt_1"
#define CONFIG_DEV_STDERR                   "/dev/external/txt_2"

////////////////////////////////////////////////////////////////////////////////////////////
//          MAPPER
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_MAPPER_MAX_FRAGMENTS        10      // max number of fragments moved 
#define CONFIG_MAPPER_MIN                  CONFIG_VFS_INODE_MIN
#define CONFIG_MAPPER_MAX                  CONFIG_VFS_INODE_MAX

////////////////////////////////////////////////////////////////////////////////////////////
//      USER SPACE SEGMENTATION / all values are number of pages
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_VMM_VSPACE_SIZE        0x100000     // virtual space           : 4   Gbytes

#define CONFIG_VMM_KENTRY_BASE        0x000004     // KENTRY zone base        : 16  Kbytes
#define CONFIG_VMM_ELF_BASE           0x000400     // ELF zone base           : 4   Mbytes
#define CONFIG_VMM_HEAP_BASE          0x000800     // HEAP zone base          : 8   Mbytes
#define CONFIG_VMM_MMAP_BASE          0x040000     // MMAP zone base          : 1   Gbytes
#define CONFIG_VMM_STACK_BASE         0x0C0000     // STACK zone base         : 3   Gbytes

#define CONFIG_VMM_KENTRY_SIZE        0x000004     // kentry vseg size        : 16  Kbytes
#define CONFIG_VMM_ARGS_SIZE          0x000004     // args vseg size          : 16  Kbytes
#define CONFIG_VMM_ENVS_SIZE          0x000008     // envs vseg size          : 32  Kbytes
#define CONFIG_VMM_STACK_SIZE         0x002000     // single stack vseg size  : 32  Mbytes
#define CONFIG_VMM_HEAP_SIZE          0x010000     // shared heap vseg size   : 256 Mbytes

#define CONFIG_VMM_GRDXT_W1           7            // number of bits for RADIX_TREE_IX1
#define CONFIG_VMM_GRDXT_W2           7            // number of bits for RADIX_TREE_IX2
#define CONFIG_VMM_GRDXT_W3           6            // number of bits for RADIX_TREE_IX3

////////////////////////////////////////////////////////////////////////////////////////////
//     PHYSICAL MEMORY MANAGEMENT        
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_PPM_PAGE_SIZE          4096         // physical page size (bytes)
#define CONFIG_PPM_PAGE_SHIFT         12           // physical page shift (bits)
#define CONFIG_PPM_PAGE_MASK          0x00000FFF   // physical page mask     
#define CONFIG_PPM_MAX_ORDER          16           // ln(total number of pages per cluster)
#define CONFIG_PPM_HEAP_ORDER         10           // ln(number of heap pages per cluster)
#define CONFIG_PPM_MAX_RSVD           32           // max reserved zones on the machine

#define CONFIG_KCM_SLOT_SIZE          64           // smallest allocated block (bytes)

#define CONFIG_PPM_PAGE_ALIGNED       __attribute__((aligned(CONFIG_PPM_PAGE_SIZE)))

////////////////////////////////////////////////////////////////////////////////////////////
//    deprecated
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_DMA_RQ_KCM_MIN         2
#define CONFIG_DMA_RQ_KCM_MAX         4
#define CONFIG_TASK_KCM_MIN           2
#define CONFIG_TASK_KCM_MAX           3
#define CONFIG_FDINFO_KCM_MIN         2
#define CONFIG_FDINFO_KCM_MAX         2
#define CONFIG_DEVFS_CTX_MIN          1
#define CONFIG_DEVFS_CTX_MAX          1
#define CONFIG_DEVFS_FILE_MIN         2
#define CONFIG_DEVFS_FILE_MAX         3
#define CONFIG_DEVFS_NODE_MIN         1
#define CONFIG_DEVFS_NODE_MAX         2
#define CONFIG_VFAT_CTX_MIN           1
#define CONFIG_VFAT_CTX_MAX           1

#define CONFIG_RAMFS_FILE_MIN         3
#define CONFIG_RAMFS_FILE_MAX	      3

#define CONFIG_VFAT_FILE_MIN          3
#define CONFIG_VFAT_FILE_MAX          3
#define CONFIG_VFAT_NODE_MIN          2
#define CONFIG_VFAT_NODE_MAX          2

#define CONFIG_EXT2_CTX_MIN           1
#define CONFIG_EXT2_CTX_MAX           1
#define CONFIG_EXT2_FILE_MIN          3
#define CONFIG_EXT2_FILE_MAX          3
#define CONFIG_EXT2_NODE_MIN          2
#define CONFIG_EXT2_NODE_MAX          2

#define CONFIG_VFS_CTX_MIN            1
#define CONFIG_VFS_CTX_MAX            1
#define CONFIG_VFS_INODE_MIN          3
#define CONFIG_VFS_INODE_MAX          6
#define CONFIG_VFS_FILE_MIN           3
#define CONFIG_VFS_FILE_MAX           5

#define CONFIG_SEMAPHORE_MIN          2
#define CONFIG_SEMAPHORE_MAX          2
#define CONFIG_CONDTION_VAR_MIN       2
#define CONFIG_CONDTION_VAR_MAX       2
#define CONFIG_BARRIER_MIN            2
#define CONFIG_BARRIER_MAX            2
#define CONFIG_RWLOCK_MIN             2
#define CONFIG_RWLOCK_MAX             2
#define CONFIG_WAITQUEUEDB_MAX        2
#define CONFIG_WAITQUEUEDB_MIN        2
#define CONFIG_RADIX_NODE_MIN         10         
#define CONFIG_RADIX_NODE_MAX         30
#define CONFIG_VM_REGION_MIN          1
#define CONFIG_VM_REGION_MAX          2
#define CONFIG_BLKIO_MIN              4
#define CONFIG_BLKIO_MAX              8
#define CONFIG_KEYREC_MIN             2
#define CONFIG_KEYREC_MAX             2



#endif	/* _KERNEL_CONFIG_H_ */
