/*
 * mips32_context.h - structures used to save MIPS32 CPU & FPU registers
 * 
 * Author  Alain Greiner    (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef  _MIPS32_CONTEXT_H_
#define  _MIPS32_CONTEXT_H_

//////////////////////////////////////////////////////////////////////////////////////////
// This file defines the MIPPS32specific structures, that are used to save /restore
// MIPS32 CPU and FPU registers at context swich.
//////////////////////////////////////////////////////////////////////////////////////////

/****************************************************************************************
 * This defines the "mips32_cpu_context_t" structure, containing general registers,
 * as well as CP0 or CP2 registers.
 * These registers are saved/restored at each context switch.
 * It can be accessed through a void* pointer contained in the thread descriptor.
 *
 * WARNING : update the hal_cpu_context_save() and hal_cpu_context_restore()
 *           functions when modifying this structure. 
 ***************************************************************************************/

typedef struct mips_32_cpu_context_s
{
	uint32_t s0_16;      // slot 0
	uint32_t s1_17;      // slot 1
	uint32_t s2_18;      // slot 2
	uint32_t s3_19;      // slot 3
	uint32_t s4_20;      // slot 4
	uint32_t s5_21;      // slot 5
	uint32_t s6_22;      // slot 6
	uint32_t s7_23;      // slot 7
	uint32_t sp_29;      // slot 8
	uint32_t fp_30;      // slot 9
	uint32_t ra_31;      // slot 10
	uint32_t c0_sr;      // slot 11
	uint32_t c0_th;      // slot 12
	uint32_t c2_ptpr;    // slot 13
	uint32_t c2_mode;    // slot 14
} 
mips32_cpu_context_t;

/****************************************************************************************
 * This defines the "mips32_fpu_context_t" structure, containing all FPU registers
 * (i.e. CP1 coprocessor registers).
 * These registers are saved/restored each time the FPU is allocated to a thread.
 * It can be accessed through a void* pointer contained in the thread descriptor.
 *
 * WARNING : update the hal_fpu_context_save() and hal_fpu_context_restore()
 *           functions when modifying this structure. 
 ***************************************************************************************/

typedef struct mips32_fpu_context_s
{
	uint32_t   fpu_regs[32];     
}
mips32_fpu_context_t;


#endif	/* _MIPS32_CONTEXT_H_ */
