/*
 * soclib_iob.h - soclib IOB driver API definition.
 *
 * Alain Greiner    (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _SOCLIB_IOB_H_
#define _SOCLIB_IOB_H_

#include <hal_types.h>
#include <chdev.h>

void soclib_iob_init( chdev_t * chdev );

void soclib_iob_set_active( xptr_t   iox_xp,
                            uint32_t value );

void soclib_iob_set_ptpr( xptr_t   iob_xp,
                          uint32_t value );

void soclib_iob_inval_page( xptr_t  iox_xp,
                            vpn_t   vpn );

uint32_t soclib_iob_get_bvar( xptr_t  iox_xp );

uint32_t soclib_iob_get_srcid( xptr_t  iox_xp );

uint32_t soclib_iob_get_error( xptr_t  iox_xp );

#endif

