/*
 * hal_syscall.h - Architecture specific syscall handler API definition.
 *
 * Author      Alain Greiner (2016,2017)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HAL_SYSCALL_H_
#define _HAL_SYSCALL_H_

#include <hal_types.h>

//////////////////////////////////////////////////////////////////////////////////////////
//     ARchitecture specific syscall handler API
//
// The calling thread context has been saved in the cpu_uzone array,
// stored in the user thread descriptor by the hal_kentry function.
// The architecture specific handler must use this array to get the syscall
// index and the arguments values.
//
// Any architecture specific implementation must implement this API.
//////////////////////////////////////////////////////////////////////////////////////////

/**** forward declaration  ****/

struct thread_s;


/*****************************************************************************************
 * This function implements the ALMOS-MKH syscall handler.
 *****************************************************************************************
 * @ this     : pointer on the calling thread.
 * @ regs_tbl : array containing the core registers values, saved by hal_kentry.
 ****************************************************************************************/
void hal_do_syscall( struct thread_s * this,
                     reg_t           * regs_tbl );


#endif   // _HAL_SYSCALL_H_
