/*
 * do_interrupt.h - Architecture independant interrupt handler definition.
 * 
 * Author    Ghassan Almaless (2008,2009,2010,2011,2012)
 *           Mohamed Lamine Karaoui (2015)
 *           Alain Greiner (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _DO_INTERRUPT_H_
#define _DO_INTERRUPT_H_

#include <hal_types.h>
#include <thread.h>

///////////////////////////////////////////////////////////////////////////////////////
// This file defines the architecture independant interrupt handler.
///////////////////////////////////////////////////////////////////////////////////////

/**************************************************************************************
 * This function is called by the hal_do_interrupt() function associated to a specific
 * hardware architecture. It makes two things:
 * - First, it access the local ICU controller to get pending interrupts for the
 *   calling core, and execute the registered ISR. It handles up to three pending
 *   interrupt at each call (one HWI, one WTI, and one PTI).
 * - Second, it check the pending signals for the interrupted thread, and call
 *   the registered signal handlers.
 **************************************************************************************
 * @ this      : pointer on the interrupted thread descriptor.
 *************************************************************************************/
void do_interrupt( thread_t * this );

#endif	/* _DO_INTERRUPT_H_ */
