/*
 * sys_clock: get calling core cycles count
 * 
 * Author    Alain Greiner (2016,2017)
 *  
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <hal_uspace.h>
#include <errno.h>
#include <core.h>
#include <thread.h>
#include <process.h>
#include <vmm.h>
#include <printk.h>

//////////////////////////////////
int sys_clock (uint64_t * cycles )
{
	error_t   error;
    paddr_t   paddr;
	uint64_t  k_cycles;

    thread_t  * this    = CURRENT_THREAD;
    process_t * process = this->process;

    // check buffer in user space
    error = vmm_v2p_translate( false , cycles , &paddr );

	if( error )
	{
        printk("\n[ERROR] in %s : user buffer unmapped for thread %x in process %x\n",
               __FUNCTION__ , this->trdid , process->pid );
        this->errno = EFAULT;
		return -1;
	}

    // call relevant core function
	k_cycles = core_get_cycles( this->core );

    // copy to user space
	hal_copy_to_uspace( cycles , &k_cycles , sizeof(uint64_t) );

	return 0; 

}  // end sys_clock()
