/*
 * do_exception.h - Architecture independant exception handler definition.
 * 
 * Author    Ghassan Almaless (2008,2009,2010,2011,2012)
 *           Mohamed Lamine Karaoui (2015)
 *           Alain Greiner (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _DO_EXCEPTION_H_
#define _DO_EXCEPTION_H_

#include <hal_types.h>
#include <thread.h>

///////////////////////////////////////////////////////////////////////////////////////
// This file defines the architecture independant exception handler.
///////////////////////////////////////////////////////////////////////////////////////

/**************************************************************************************
 * This enum defines the various error codes returned by this generic
 * exception handler to the architecture specific exception handler.
 *************************************************************************************/

typedef enum
{
	EXCP_NON_FATAL     = 0,   // page fault of FPU unusable handled => non fatal
	EXCP_USER_ERROR    = 1,   // User error => user process will receive a SIGSEGV
    EXCP_KERNEL_PANIC  = 2,   // Kernel error => kernel panic
}
excp_classes_t;

/**************************************************************************************
 * This defines the masks used to analyse the MMU exception code
 * TODO : these values have been defined to fit the TSAR MMU, 
 * but a more generic abstraction must be defined...
 *************************************************************************************/

#define    MMU_EXCP_PAGE_UNMAPPED   0x0003    // page fault (PTE unmapped)
#define    MMU_EXCP_USER_PRIVILEGE  0x0004    // user access to a kernel segment
#define    MMU_EXCP_USER_WRITE      0x0008    // user access to non writable segment
#define    MMU_EXCP_USER_EXEC       0x0010    // user access to non executable segment

/**************************************************************************************
 * This function is called by the hal_do_exception() function associated to a specific
 * hardware architecture.
 * The fatal errors are mostly handled by the architecture specific handler,
 * and this generic handler handles only two non fatal exceptions types:
 * - MMU page fault
 * - FPU unavailable
 * As some MMU exceptions can be fatal, the returned error code can take three values:
 * - Non Fatal Exception
 * - Fatal User Error
 * - Kernel Panic Error
 **************************************************************************************
 * @ this      : pointer on the faulty (user) thread descriptor.
 * @ is_mmu    : MMU exception if true / FPU exception if false
 * @ return an error code in [EXCP_NON_FATAL / EXCP_USER_ERROR / EXCP_KERNEL_PANIC]
 *************************************************************************************/
error_t do_exception( thread_t * this,
                      bool_t     is_mmu );

#endif	/* _DO_EXCEPTION_H_ */
