/*
 * hal_acpi.h - ACPI-specific values and structures
 * 
 * Copyright (c) 2017 Maxime Villard
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH.; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

void hal_acpi_init();

#define ACPI_RSDP_ALIGN	16
#define ACPI_RSDP_SIGNATURE	"RSD PTR "
#define ACPI_RSDP_SIGNATURE_SIZE	8

#define ACPI_OEM_ID_SIZE	6

struct acpi_table_rsdp {
	char Signature[8];               /* ACPI signature, contains "RSD PTR " */
	uint8_t Checksum;                /* ACPI 1.0 checksum */
	char OemId[ACPI_OEM_ID_SIZE];    /* OEM identification */
	uint8_t Revision;                /* Must be (0) for ACPI 1.0 or (2) for ACPI 2.0+ */
	uint32_t RsdtPhysicalAddress;    /* 32-bit physical address of the RSDT */
	uint32_t Length;                 /* Table length in bytes, including header (ACPI 2.0+) */
	uint64_t XsdtPhysicalAddress;    /* 64-bit physical address of the XSDT (ACPI 2.0+) */
	uint8_t ExtendedChecksum;        /* Checksum of entire table (ACPI 2.0+) */
	uint8_t Reserved[3];             /* Reserved, must be zero */
} __packed;

typedef struct acpi_table_rsdp	rsdp_t;
