/*
 * hal_switch.h - TSAR architecture context switch function
 * 
 * Copyright (c) 2008,2009,2010,2011,2012 Ghassan Almaless
 * Copyright (c) 2011,2012 UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-kernel.
 *
 * ALMOS-kernel is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-kernel is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-kernel; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HAL_SWITCH_H_
#define _HAL_SWITCH_H_

/*************************************************************************************
 * The hal_do_switch() function is an assembly level code called by the
 * hal_cpu_context_switch() function to make the actual context swich.
 * The hal_cpu_context_t structure used to store a core context is defined
 * in the TSAR specific hal_context.c file.
 * The following core registers are saved in the old context & and restored
 * from the new context:
 * - GPR : all, but (zero, k0, k1), plus (hi, lo)
 * - CP0 : c0_th , c0_sr 
 * - CP2 : c2_ptpr , C2_mode, C2_epc
 * When the switch is completed, it jumps to address contained in register $31
 * of the new context.
 *************************************************************************************
 * @ ctx_old  : local pointer on the old thread context.
 * @ ctx_new  : local pointer on the new thread context.
 ************************************************************************************/
void hal_do_switch( void * ctx_old,
                    void * ctx_new );


#endif	/* _HAL_SWITCH_H_ */
