/*
 * mips32_uzone.h - structures used to save MIPS32 core registers
 * 
 * Author  Alain Greiner    (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef  _MIPS32_UZONE_REGS_H_
#define  _MIPS32_UZONE_REGS_H_

//////////////////////////////////////////////////////////////////////////////////////////
// This file defines the MIPS32 specific mnemonics to access the "uzone", that is
// a fixed size array of 32 bits integers, used by the kentry function to save/restore 
// the MIPS32 CPU registers, at each exception / interruption / syscall.
// It also defines several initial values for the SR register.
//
// This file is included in the TSAR_MIPS32 specific hal_kentry.S, hal_syscall.c,
// hal_exception.c, and hal_interrupt.c files.
//////////////////////////////////////////////////////////////////////////////////////////

/****************************************************************************************
 * This defines  SR values for TSAR-MIPS32 
 ***************************************************************************************/

#define SR_USR_MODE       0xFC11
#define SR_USR_MODE_FPU   0x2000FC11
#define SR_SYS_MODE       0xFC00

/****************************************************************************************
 * This defines the "uzone" mnemonics and size.
 ***************************************************************************************/

#define      UZ_KSP          0    // kernel stack pointer
#define      UZ_AT           1
#define      UZ_V0           2
#define      UZ_V1           3
#define      UZ_A0           4 
#define      UZ_A1           5
#define      UZ_A2           6
#define      UZ_A3           7
#define      UZ_T0           8
#define      UZ_T1           9
#define      UZ_T2           10
#define      UZ_T3           11
#define      UZ_T4           12
#define      UZ_T5           13
#define      UZ_T6           14
#define      UZ_T7           15
#define      UZ_T8           16
#define      UZ_T9           17
#define      UZ_S0           18
#define      UZ_S1           19
#define      UZ_S2           20
#define      UZ_S3           21
#define      UZ_S4           22
#define      UZ_S5           23
#define      UZ_S6           24
#define      UZ_S7           25
#define      UZ_S8           26
#define      UZ_GP           27
#define      UZ_RA           28
#define      UZ_EPC          29   // CP0 Exception Program Counter
#define      UZ_CR           30   // CP0 Cause register
#define      UZ_SP           31   // user stack pointer
#define      UZ_SR           32   // CP0 Status Register
#define      UZ_LO           33
#define      UZ_HI           34
#define      UZ_DEXT	     35   // CP2 data paddr extension
#define      UZ_MODE	     36   // CP2 MMU mode

#define      CPU_REGS_NR     37


#endif	/* _MIPS32_UZONE_REGS_H_ */
