/***************************************************************************************
 * This is the linker script for the ALMOS-MKH kernel code on the TSAR architecture.
 * It describes the memory layout for the "kernel.elf" binary file, containing three 
 * loadable segments, that MUST be identity mapped for the TSAR architecture. 
 * 
 * WARNING the seg_kentry_base and seg_kcode_base defined below must be kept coherent
 * with the values defined in the boot_config.h file used by the TSAR bootloader. 
 **************************************************************************************/

/* Define the kernel code base address */

seg_kcode_base  = 0x00008000;
seg_kentry_base = 0x00004000;

/* Set the entry point (e_entry field in the "kernel.elf" file header) */

ENTRY(kernel_init)

/* Describe how to group the sections */

SECTIONS
{
	. = seg_kcode_base;
	seg_kcode :
	{
		*(.text)
		*(.rodata*)
	}

	. = ALIGN(0x1000);

	seg_kdata :
	{
		*(.kinfo)
		*(.kidle)
		*(.kdata*)
		*(.data*)
	}

    . = seg_kentry_base;
    seg_kentry :
    {
		*(.kentry)
    }
}
