/*
 * nostdio.h - User side non-standard syscalls API.
 * 
 * Author     Alain Greiner (2016,2017)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _NOSTD_H_
#define _NOSTD_H_

/*************************************************************************************** 
 * This function uses the relevant syscall to return the hardware platform parameters.
 ***************************************************************************************
 * @ x_size   : [out] number of clusters in a row.
 * @ y_size   : [out] number of clusters in a column.
 * @ ncores   : [out] number of cores per cluster.
 * @ return 0 if success / return -1 if illegal pointers arguments.
 **************************************************************************************/
int get_config( unsigned int * x_size,
                unsigned int * y_size,
                unsigned int * ncores );

/*************************************************************************************** 
 * This function uses the relevant syscall to returns the cluster an local index
 * for the calling core.
 ***************************************************************************************
 * @ cxy      : [out] cluster identifier.
 * @ lid      : [out] core local index in cluster.
 * @ return 0 if success / return -1 if illegal pointers arguments.
 **************************************************************************************/
int get_core( unsigned int * cxy,
              unsigned int * lid );

/***************************************************************************************
 * This function uses the relevant syscall to returns the calling core cycles counter,
 * taking into account a possible overflow on 32 bits architectures.
 ***************************************************************************************
 * @ cycle    : [out] current cycle value.
 * @ return 0 if success / return -1 if illegal pointer argument.
 **************************************************************************************/
int get_cycle( unsigned long long * cycle );

/*************************************************************************************** 
 * This function uses the relevant syscall to display the state of the scheduler
 * identified by the <cxy> and <lid> arguments.
 ***************************************************************************************
 * @ cxy      : [in] target cluster identifier.
 * @ lid      : [in] target core local index.
 * @ return 0 if success / return -1 if illegal arguments.
 **************************************************************************************/
int get_sched( unsigned int  cxy,
               unsigned int  lid );

/*************************************************************************************** 
 * This function uses the relevant syscall to display on the kernel terminal a debug 
 * message in case of panic (such as a printf failure).
 * This message contains the thread / process / core identifiers, and the cause,
 * as defined by the <string> argument. 
 ***************************************************************************************
 * @ string    : [in] cause of user panic.
 **************************************************************************************/
void panic( char * string );



#endif // _NOSTD_H_

