/*
 * kernel_config.h - global kernel configuration arguments
 * 
 * Authors  Ghassan Almaless (2008,2009,2010,2011,2012) 
 *          Mohamed Lamine Karaoui (2015)
 *          Alain Greiner (2016)
 *
 * Copyright (c)  UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _ALMOS_CONFIG_H_
#define _ALMOS_CONFIG_H_

#define CONFIG_ALMOS_VERSION                "Version 1.0 / March 2017"

////////////////////////////////////////////////////////////////////////////////////////////
//                              KERNEL DEBUG
//
//  For all these debug variables: 
//  - trace is generated only when cycle > debug_value.
//  - detailed trace is enabled when (debug_value & Ox1) is non zero.
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_CHDEV_DEBUG            0
#define CONFIG_CLUSTER_DEBUG          0
#define CONFIG_CONTEXT_DEBUG          0
#define CONFIG_CORE_DEBUG             0
#define CONFIG_DEVFS_DEBUG            0
#define CONFIG_DMA_DEBUG              0
#define CONFIG_DQDT_DEBUG             0
#define CONFIG_ELF_DEBUG              0
#define CONFIG_EXEC_DEBUG             2
#define CONFIG_EXCP_DEBUG             0
#define CONFIG_FATFS_DEBUG            0
#define CONFIG_FBF_DEBUG              0
#define CONFIG_FORK_DEBUG             2 
#define CONFIG_GPT_DEBUG              0
#define CONFIG_GRPC_DEBUG             2
#define CONFIG_IDLE_DEBUG             0
#define CONFIG_IOC_DEBUG              0
#define CONFIG_IRQ_DEBUG              0
#define CONFIG_KCM_DEBUG              0
#define CONFIG_KENTRY_DEBUG           0
#define CONFIG_KHM_DEBUG              0
#define CONFIG_KILL_DEBUG             0 
#define CONFIG_KINIT_DEBUG            0
#define CONFIG_KMEM_DEBUG             0
#define CONFIG_LOCKS_DEBUG            0
#define CONFIG_MMAP_DEBUG             0         
#define CONFIG_MMC_DEBUG              0
#define CONFIG_MAPPER_DEBUG           0
#define CONFIG_NIC_DEBUG              0
#define CONFIG_PIC_DEBUG              0
#define CONFIG_PPM_DEBUG              0
#define CONFIG_PROCESS_DEBUG          0
#define CONFIG_READ_DEBUG             0
#define CONFIG_RPC_DEBUG              0
#define CONFIG_SCHED_DEBUG            0      
#define CONFIG_SIGACTION_DEBUG        2
#define CONFIG_SYSCALL_DEBUG          0
#define CONFIG_THREAD_DEBUG           0
#define CONFIG_TXT_DEBUG              0
#define CONFIG_VFS_DEBUG              0
#define CONFIG_VMM_DEBUG              0
#define CONFIG_WRITE_DEBUG            0

////////////////////////////////////////////////////////////////////////////////////////////
//                          HARDWARE CONFIGURATION     
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_KERNEL_IDENTITY_MAP          true       // True for 32 bits cores             
#define CONFIG_MAX_CLUSTER                  256        // max number of clusters
#define CONFIG_MAX_LOCAL_CORES              4          // max number of cores per cluster
#define CONFIG_MAX_INT_DEV                  4          // max number of internal peripherals
#define CONFIG_MAX_EXT_DEV                  8          // max number of external peripherals
#define CONFIG_MAX_INTERNAL_IRQS            32         // max number of HWI per ICU
#define CONFIG_MAX_EXTERNAL_IRQS            32         // max number of PTI per ICU
#define CONFIG_IRQS_PER_CORE                4          // number of input IRQs per core
#define CONFIG_CLUSTER_SPAN                 32         // ln(phys. address space per cluster)
#define CONFIG_CACHE_LINE_SIZE              64         // number of bytes in cache line

#define CONFIG_CACHE_LINE_ALIGNED           __attribute__((aligned(CONFIG_CACHE_LINE_SIZE)))

#define CONFIG_MAX_IOC_CHANNELS             1          // max number of IOC device channels
#define CONFIG_MAX_FBF_CHANNELS             1          // max number of FBF device channels
#define CONFIG_MAX_TXT_CHANNELS             8          // max number of TXT device channels
#define CONFIG_MAX_DMA_CHANNELS             4          // max number of DMA device channels
#define CONFIG_MAX_NIC_CHANNELS             4          // max number of NIC device channels

#define CONFIG_MAX_CLUSTERS                 256        // max number of clusters

#define CONFIG_TXT_ECHO_MODE                1          // echo mode for TXT peripheral
#define CONFIG_TXT_KBUF_SIZE                256        // kernel buffer for TXT write

#define CONFIG_FBF_WIDTH                    128
#define CONFIG_FBF_HEIGHT                   128

#define CONFIG_CPU_CTX_SIZE                 256        // up to 64 uint32_t registers
#define CONFIG_FPU_CTX_SIZE                 256        // up to 32 uint64_t registers
#define CONFIG_NIC_CHBUF_DEPTH              1          // number of containers in NIC chbuf

////////////////////////////////////////////////////////////////////////////////////////////
//                            PROCESS MANAGEMENT       
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_MAX_PROCESS_PER_CLUSTER      128        // max number of owned process
#define CONFIG_PROCESS_FILE_MAX_NR          8          // max number of open files
#define CONFIG_PROCESS_MAX_CHILDREN         1024       // max number of children process
#define CONFIG_PROCESS_HEAP_MIN_SIZE        0x00010000 // user heap min size (bytes)
#define CONFIG_PROCESS_HEAP_MAX_SIZE        0x30000000 // user heap max size (bytes)
#define CONFIG_PROCESS_INIT_PATH            "/bin/user/ksh.elf"

////////////////////////////////////////////////////////////////////////////////////////////
//                            VIRTUAL FILE SYSTEM        
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_VFS_MAX_INODES               128        // max number of inodes per cluster
#define CONFIG_VFS_MAX_NAME_LENGTH          32         // dentry name max length (bytes)
#define CONFIG_VFS_MAX_PATH_LENGTH          256        // pathname max length (bytes)

#define CONFIG_VFS_ROOT_IS_FATFS            1          // root FS is FATFS if non zero
#define CONFIG_VFS_ROOT_IS_EX2FS            0          // root FS is EX2FS if non zero

////////////////////////////////////////////////////////////////////////////////////////////
//                                 LOCKS          
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_RWLOCK_DELAY                 50       // iterations number ( ~ 200 cycles )

////////////////////////////////////////////////////////////////////////////////////////////
//                                  DQDT        
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_DQDT_LEVELS_NR               5
#define CONFIG_DQDT_TICKS_PER_QUANTUM       1        // number of ticks between updates

////////////////////////////////////////////////////////////////////////////////////////////
//                              RANDOM NUMBERS 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_RDNG_PARAM_A                 65519
#define CONFIG_RDNG_PARAM_C                 64037

////////////////////////////////////////////////////////////////////////////////////////////
//                                SCHEDULING 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_SCHED_TICK_MS_PERIOD         1000    // number of milliseconds
#define CONFIG_SCHED_TICKS_PER_QUANTUM      1       // number of ticks between scheduling
#define CONFIG_SCHED_MAX_THREADS_NR         32      // max number of threads per core

////////////////////////////////////////////////////////////////////////////////////////////
//                                 THREADS 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_THREAD_MAX_PER_CLUSTER       16      // max threads per cluster & process
#define CONFIG_THREAD_DESC_SIZE             0x4000  // thread desc size (with kernel stack)
#define CONFIG_THREAD_DESC_ORDER            2       // ln( number of 4K pages )
#define CONFIG_THREAD_IDLE_MODE_SLEEP       0       // idle thread enter sleep mode 

////////////////////////////////////////////////////////////////////////////////////////////
//                             REMOTE PROCEDURE CALL
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_REMOTE_FIFO_SLOTS		    16
#define CONFIG_REMOTE_FIFO_MAX_ITERATIONS   1024

#define CONFIG_RPC_PENDING_MAX              8      // max requests handled by one server 
#define CONFIG_RPC_THREADS_MAX              8      // max number of RPC threads per core

////////////////////////////////////////////////////////////////////////////////////////////
//                     PROCESS INIT & PROCESS USER TERMINALS
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_INIT_STDIN                    "/dev/external/txt1_rx"
#define CONFIG_INIT_STDOUT                   "/dev/external/txt1_tx"
#define CONFIG_INIT_STDERR                   "/dev/external/txt1_tx"

#define CONFIG_USER_STDIN                    "/dev/external/txt2_rx"
#define CONFIG_USER_STDOUT                   "/dev/external/txt2_tx"
#define CONFIG_USER_STDERR                   "/dev/external/txt2_tx"

////////////////////////////////////////////////////////////////////////////////////////////
//                                  MAPPER
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_MAPPER_MAX_FRAGMENTS        10      // max number of fragments moved 
#define CONFIG_MAPPER_MIN                  CONFIG_VFS_INODE_MIN
#define CONFIG_MAPPER_MAX                  CONFIG_VFS_INODE_MAX

////////////////////////////////////////////////////////////////////////////////////////////
//                USER SPACE SEGMENTATION / all values are number of pages
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_VMM_VSPACE_SIZE        0x100000     // virtual space          : 4   Gbytes

#define CONFIG_VMM_KENTRY_BASE        0x000004     // UTILS zone base        : 16  Kbytes
#define CONFIG_VMM_ELF_BASE           0x000400     // ELF zone base          : 4   Mbytes
#define CONFIG_VMM_HEAP_BASE          0x002000     // HEAP zone base         : 32  Mbytes
#define CONFIG_VMM_STACK_BASE         0x0F0000     // STACK zone base        : 3.7 Gbytes

#define CONFIG_VMM_KENTRY_SIZE        0x000004     // kentry vseg size       : 16  Kbytes
#define CONFIG_VMM_ARGS_SIZE          0x000004     // args vseg size         : 16  Kbytes
#define CONFIG_VMM_ENVS_SIZE          0x000008     // envs vseg size         : 32  Kbytes
#define CONFIG_VMM_STACK_SIZE         0x000100     // single stack vseg size : 1   Mbytes

#define CONFIG_VMM_GRDXT_W1           7            // number of bits for RADIX_TREE_IX1
#define CONFIG_VMM_GRDXT_W2           7            // number of bits for RADIX_TREE_IX2
#define CONFIG_VMM_GRDXT_W3           6            // number of bits for RADIX_TREE_IX3

////////////////////////////////////////////////////////////////////////////////////////////
//     PHYSICAL MEMORY MANAGEMENT (GENERIC)        
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_PPM_PAGE_SIZE          4096         // physical page size (bytes)
#define CONFIG_PPM_PAGE_SHIFT         12           // physical page shift (bits)
#define CONFIG_PPM_PAGE_MASK          0x00000FFF   // physical page mask     
#define CONFIG_PPM_MAX_ORDER          16           // ln(total number of pages per cluster)
#define CONFIG_PPM_HEAP_ORDER         10           // ln(number of heap pages per cluster)
#define CONFIG_PPM_MAX_RSVD           32           // max reserved zones on the machine

#define CONFIG_KCM_SLOT_SIZE          64           // smallest allocated block (bytes)

#define CONFIG_PPM_PAGE_ALIGNED       __attribute__((aligned(CONFIG_PPM_PAGE_SIZE)))



////////////////////////////////////////////////////////////////////////////////////////////
//    deprecated
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_DMA_RQ_KCM_MIN         2
#define CONFIG_DMA_RQ_KCM_MAX         4
#define CONFIG_TASK_KCM_MIN           2
#define CONFIG_TASK_KCM_MAX           3
#define CONFIG_FDINFO_KCM_MIN         2
#define CONFIG_FDINFO_KCM_MAX         2
#define CONFIG_DEVFS_CTX_MIN          1
#define CONFIG_DEVFS_CTX_MAX          1
#define CONFIG_DEVFS_FILE_MIN         2
#define CONFIG_DEVFS_FILE_MAX         3
#define CONFIG_DEVFS_NODE_MIN         1
#define CONFIG_DEVFS_NODE_MAX         2
#define CONFIG_VFAT_CTX_MIN           1
#define CONFIG_VFAT_CTX_MAX           1

#define CONFIG_RAMFS_FILE_MIN         3
#define CONFIG_RAMFS_FILE_MAX	      3

#define CONFIG_VFAT_FILE_MIN          3
#define CONFIG_VFAT_FILE_MAX          3
#define CONFIG_VFAT_NODE_MIN          2
#define CONFIG_VFAT_NODE_MAX          2

#define CONFIG_EXT2_CTX_MIN           1
#define CONFIG_EXT2_CTX_MAX           1
#define CONFIG_EXT2_FILE_MIN          3
#define CONFIG_EXT2_FILE_MAX          3
#define CONFIG_EXT2_NODE_MIN          2
#define CONFIG_EXT2_NODE_MAX          2

#define CONFIG_VFS_CTX_MIN            1
#define CONFIG_VFS_CTX_MAX            1
#define CONFIG_VFS_INODE_MIN          3
#define CONFIG_VFS_INODE_MAX          6
#define CONFIG_VFS_FILE_MIN           3
#define CONFIG_VFS_FILE_MAX           5

#define CONFIG_SEMAPHORE_MIN          2
#define CONFIG_SEMAPHORE_MAX          2
#define CONFIG_CONDTION_VAR_MIN       2
#define CONFIG_CONDTION_VAR_MAX       2
#define CONFIG_BARRIER_MIN            2
#define CONFIG_BARRIER_MAX            2
#define CONFIG_RWLOCK_MIN             2
#define CONFIG_RWLOCK_MAX             2
#define CONFIG_WAITQUEUEDB_MAX        2
#define CONFIG_WAITQUEUEDB_MIN        2
#define CONFIG_RADIX_NODE_MIN         10         
#define CONFIG_RADIX_NODE_MAX         30
#define CONFIG_VM_REGION_MIN          1
#define CONFIG_VM_REGION_MAX          2
#define CONFIG_BLKIO_MIN              4
#define CONFIG_BLKIO_MAX              8
#define CONFIG_KEYREC_MIN             2
#define CONFIG_KEYREC_MAX             2



#endif	/* _KERNEL_CONFIG_H_ */
