/*
 * nostdio.c - User side non-standard syscalls API implementation.
 * 
 * Author     Alain Greiner (2016,2017)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include  <shared_syscalls.h>
#include  <hal_user.h>

#define   reg_t    int 


//////////////////////////////////////
int get_config( unsigned int * x_size,
                unsigned int * y_size,
                unsigned int * ncores )
{
    return hal_user_syscall( SYS_GET_CONFIG,
                             (reg_t)x_size,
                             (reg_t)y_size,
                             (reg_t)ncores, 0 );
}

/////////////////////////////////
int get_core( unsigned int * cxy,
              unsigned int * lid )
{
    return hal_user_syscall( SYS_GET_CORE,
                             (reg_t)cxy,
                             (reg_t)lid, 0, 0 );
}

///////////////////////////////////////////
int get_cycle( unsigned long long * cycle )
{
    return hal_user_syscall( SYS_GET_CYCLE,
                             (reg_t)cycle, 0, 0, 0 );
}

////////////////////////////////
int get_sched( unsigned int cxy,
               unsigned int lid )
{
    return hal_user_syscall( SYS_GET_SCHED,
                             (reg_t)cxy,
                             (reg_t)lid, 0, 0 );
} 

///////////////////////////
void panic( char * string )
{
    hal_user_syscall( SYS_PANIC,
                      (reg_t)string, 0, 0, 0 );
}
